/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.viewholder;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.util.DiscoverUserHelper;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleEvent;
import com.edu24ol.newclass.discover.widget.DiscoverItemMenuWindow;
import com.edu24ol.newclass.discover.widget.article.DiscoverArticleHeaderView;
import com.edu24ol.newclass.discover.widget.article.IArticleView;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.adapter.BaseViewHolderNew;
import com.hqwx.android.service.difference.DifferenceConfig;
import java.util.List;

public class DiscoverBaseArticleItemViewHolder<K extends ViewGroup>
extends BaseViewHolderNew<ArticleInfo> {
    protected DiscoverArticleHeaderView mHeaderView;
    protected IArticleView<K> mArticleView = this.getArticleView();
    protected DiscoverArticleEvent.HeaderEventListener mHeaderEventListener;
    protected DiscoverArticleEvent.MoreMenuEventListener mMoreMenuEventListener;
    private boolean isShowAttention;
    private boolean isShowMoreButton;
    private boolean isShowTag;

    public DiscoverBaseArticleItemViewHolder(Context context, View itemView) {
        super(context, itemView);
        this.mHeaderView = this.initHeaderView(context, itemView);
        this.initHeaderViewListener();
    }

    public DiscoverArticleHeaderView initHeaderView(Context context, View itemView) {
        return (DiscoverArticleHeaderView)itemView.findViewById(R.id.discover_header_view);
    }

    protected IArticleView<K> getArticleView() {
        return (IArticleView)this.itemView.findViewById(R.id.article_content_view);
    }

    protected void initHeaderViewListener() {
        this.mHeaderView.setEventClickListener(new DiscoverArticleHeaderView.EventClickListener(){

            @Override
            public void onMoreClick(View view) {
                final ArticleInfo articleInfo = (ArticleInfo)DiscoverBaseArticleItemViewHolder.this.itemView.getTag();
                if (articleInfo == null) {
                    return;
                }
                DiscoverItemMenuWindow discoverItemMenuWindow = new DiscoverItemMenuWindow(articleInfo, view.getContext());
                discoverItemMenuWindow.setMenuItemClickListener(new DiscoverItemMenuWindow.MenuItemClickListener(){

                    @Override
                    public void onShareClick() {
                        if (DiscoverBaseArticleItemViewHolder.this.mMoreMenuEventListener != null) {
                            DiscoverBaseArticleItemViewHolder.this.mMoreMenuEventListener.onMenuShareClick(articleInfo);
                        }
                    }

                    @Override
                    public void onReportClick() {
                        if (DiscoverBaseArticleItemViewHolder.this.mMoreMenuEventListener != null) {
                            DiscoverBaseArticleItemViewHolder.this.mMoreMenuEventListener.onMenuReportClick(articleInfo);
                        }
                    }

                    @Override
                    public void onDeleteClick() {
                        if (DiscoverBaseArticleItemViewHolder.this.mMoreMenuEventListener != null) {
                            DiscoverBaseArticleItemViewHolder.this.mMoreMenuEventListener.onMenuDeleteClick(articleInfo);
                        }
                    }
                });
                discoverItemMenuWindow.show(view);
            }

            @Override
            public void onAttentionClick(CheckBox checkBox) {
                ArticleInfo articleInfo = (ArticleInfo)DiscoverBaseArticleItemViewHolder.this.itemView.getTag();
                if (articleInfo == null || articleInfo.author == null) {
                    return;
                }
                if (DiscoverBaseArticleItemViewHolder.this.mHeaderEventListener != null) {
                    DiscoverBaseArticleItemViewHolder.this.mHeaderEventListener.onAttentionClick(checkBox, articleInfo.author, checkBox.isChecked());
                }
            }
        });
        this.mHeaderView.setOnClickListener(v -> {
            ArticleInfo articleInfo = (ArticleInfo)this.itemView.getTag();
            if (articleInfo == null || articleInfo.author == null) {
                return;
            }
            if (DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()) {
                return;
            }
            if (this.mHeaderEventListener != null) {
                this.mHeaderEventListener.onAuthorInfoClick(articleInfo.author);
            }
        });
    }

    public void onBindViewHolder(Context context, ArticleInfo articleInfo, int position) {
        this.setAttentionAndMoreState(articleInfo);
        this.mHeaderView.refresh(articleInfo);
        this.itemView.setTag((Object)articleInfo);
        this.itemView.setTag(R.id.tag_position, (Object)position);
        this.mArticleView.refreshArticleInfo(articleInfo, position, this.isShowTag());
    }

    public void onBindViewHolder(Context context, ArticleInfo articleInfo, List payloads, int position) {
        String payLoad = (String)payloads.get(0);
        if ("attention".equals(payLoad)) {
            this.mHeaderView.refreshAttentionState(articleInfo);
        }
    }

    public void setHeaderEventListener(DiscoverArticleEvent.HeaderEventListener headerEventListener) {
        this.mHeaderEventListener = headerEventListener;
    }

    public void setMoreMenuEventListener(DiscoverArticleEvent.MoreMenuEventListener moreMenuEventListener) {
        this.mMoreMenuEventListener = moreMenuEventListener;
    }

    public boolean isShowTag() {
        return this.isShowTag;
    }

    public void setShowTag(boolean showTag) {
        this.isShowTag = showTag;
    }

    public boolean isShowAttention() {
        return this.isShowAttention;
    }

    public void setShowAttention(boolean showAttention) {
        this.isShowAttention = showAttention;
    }

    public boolean isShowMoreButton() {
        return this.isShowMoreButton;
    }

    public void setShowMoreButton(boolean showMoreButton) {
        this.isShowMoreButton = showMoreButton;
    }

    protected void setAttentionAndMoreState(ArticleInfo articleInfo) {
        boolean isArticleOwner = articleInfo.isCurrentLoginUserEqualAuthor(DiscoverUserHelper.getUserId());
        this.mHeaderView.showAttentionView(this.isShowAttention() && !isArticleOwner);
        this.mHeaderView.showMoreView(this.isShowMoreButton());
    }

    public void setContentTextSize(float size) {
        TextView contentView = this.mArticleView.getContentView();
        if (contentView != null) {
            contentView.setTextSize(2, size);
        }
    }

    public void setAuthorNameTextSize(float size) {
        this.mHeaderView.onSetAuthorNameTextSize(size);
    }

    public void setAuthorNameTextStyle(boolean fakeBoldText) {
        this.mHeaderView.onSetAuthorNameTextStyle(fakeBoldText);
    }

    public void setAuthorNameTextColor(int color2) {
        this.mHeaderView.onSetAuthorNameTextColor(color2);
    }
}

