/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.util;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import androidx.constraintlayout.widget.Group;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import base.ListVideoPlayItem;
import base.VideoDefinition;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.Network;
import com.hqwx.android.playercontroller.ListVideoItemView;
import com.hqwx.android.service.ServiceFactory;
import com.yy.android.educommon.log.YLog;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class ScrollCalculatorHelper {
    private Context mContext;
    private ListVideoItemView mLastVideoItemView;
    private HashMap<Long, Long> videoPlayPositionCache = new HashMap();
    ArrayList<ListVideoItemView> visibleVideoItemViewList = new ArrayList();
    private ListVideoItemView.VideoEventListener mVideoEventListener = new ListVideoItemView.VideoEventListener(){

        public void onCompletion(ListVideoItemView listVideoItemView) {
            ScrollCalculatorHelper.this.setDefaultVideoImageViewVisible(listVideoItemView, true);
            listVideoItemView.setVisibility(8);
            if (listVideoItemView.getTag() != null) {
                ArticleInfo articleInfo = (ArticleInfo)listVideoItemView.getTag();
                if (ScrollCalculatorHelper.this.videoPlayPositionCache.containsKey(articleInfo.id)) {
                    ScrollCalculatorHelper.this.videoPlayPositionCache.remove(articleInfo.id);
                }
            }
        }

        public void onSurfaceDestroy(ListVideoItemView listVideoItemView) {
            ScrollCalculatorHelper.this.stopPlayVideo(listVideoItemView);
        }

        public void onError(ListVideoItemView listVideoItemView) {
            ScrollCalculatorHelper.this.stopPlayVideo(listVideoItemView);
        }
    };

    public ScrollCalculatorHelper(Context context) {
        this.mContext = context;
    }

    public void reset() {
    }

    public void onScrollStateChanged(RecyclerView view, int scrollState) {
        switch (scrollState) {
            case 0: {
                this.onScrollPlayVideo(view);
                break;
            }
        }
    }

    public void onScrolled(RecyclerView view, int dx, int dy) {
    }

    public void onScrollPlayVideo(RecyclerView view) {
        if (view == null) {
            return;
        }
        this.visibleVideoItemViewList.clear();
        LinearLayoutManager layoutManager = (LinearLayoutManager)view.getLayoutManager();
        ListVideoItemView videoItemView = null;
        ListVideoItemView lastVideoItemView = this.mLastVideoItemView;
        int childCount = layoutManager.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ListVideoItemView currentVideoItemView;
            Object rangeTargetView;
            int playId = R.id.item_video_view;
            if (layoutManager.getChildAt(i) == null || layoutManager.getChildAt(i).findViewById(playId) == null || !this.isViewInPlayRange((View)(rangeTargetView = (currentVideoItemView = (ListVideoItemView)layoutManager.getChildAt(i).findViewById(playId)).getVisibility() == 0 ? currentVideoItemView : layoutManager.getChildAt(i).findViewById(R.id.item_discover_recommend_img)))) continue;
            this.visibleVideoItemViewList.add(currentVideoItemView);
        }
        if (this.visibleVideoItemViewList.size() > 1) {
            videoItemView = this.getCloseAtScreenCenterView(this.visibleVideoItemViewList);
        } else if (this.visibleVideoItemViewList.size() == 1) {
            videoItemView = this.visibleVideoItemViewList.get(0);
        }
        if (videoItemView == null) {
            if (lastVideoItemView != null) {
                this.pauseVideo(lastVideoItemView);
                this.mLastVideoItemView = null;
            }
        } else {
            Network.Type networkType = Network.getNetworkType((Context)this.mContext);
            if (networkType == Network.Type.WIFI && ServiceFactory.getAppService().isAutoPlayListVideo()) {
                this.playVideo(videoItemView);
                this.mLastVideoItemView = videoItemView;
                if (lastVideoItemView != null && lastVideoItemView.getPlayListItem() != videoItemView.getPlayListItem()) {
                    this.pauseVideo(lastVideoItemView);
                }
            }
        }
    }

    public boolean isViewInPlayRange(View targetView) {
        int viewHeight = targetView.getHeight();
        if (viewHeight <= 0) {
            return false;
        }
        Rect rect = new Rect();
        targetView.getLocalVisibleRect(rect);
        int outOfHeight = targetView.getHeight() / 2;
        int height = targetView.getHeight();
        if (rect.top == 0 && rect.bottom >= outOfHeight) {
            return true;
        }
        return rect.top <= outOfHeight && rect.bottom == height;
    }

    public <T extends View> T getCloseAtScreenCenterView(ArrayList<T> list) {
        int screenCenterY;
        int minDistance = screenCenterY = DisplayUtils.getScreenHeight((Context)this.mContext) / 2;
        int minDistanceViewPosition = 0;
        for (int i = 0; i < list.size(); ++i) {
            View targetView = (View)list.get(i);
            Rect rect = new Rect();
            targetView.getGlobalVisibleRect(rect);
            int viewCenterY = rect.bottom - targetView.getHeight() / 2;
            if (viewCenterY > minDistance) continue;
            minDistance = viewCenterY;
            minDistanceViewPosition = i;
        }
        return (T)((View)list.get(minDistanceViewPosition));
    }

    public boolean isViewOutOfScreen(View targetView) {
        Rect rect = new Rect();
        targetView.getLocalVisibleRect(rect);
        int outOfHeight = targetView.getHeight() / 2;
        if (rect.top == 0 && rect.bottom < outOfHeight) {
            return true;
        }
        return rect.top > outOfHeight && rect.bottom == targetView.getHeight();
    }

    private void playVideo(final ListVideoItemView videoItemView) {
        if (!videoItemView.isPlaying()) {
            videoItemView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ScrollCalculatorHelper.this.setDefaultVideoImageViewVisible(videoItemView, false);
                    videoItemView.setVisibility(0);
                    long lastPlayPosition = 0L;
                    if (videoItemView.getTag() != null) {
                        ArticleInfo articleInfo = (ArticleInfo)videoItemView.getTag();
                        if (ScrollCalculatorHelper.this.videoPlayPositionCache.containsKey(articleInfo.id)) {
                            lastPlayPosition = (Long)ScrollCalculatorHelper.this.videoPlayPositionCache.get(articleInfo.id);
                        }
                        videoItemView.setPlayItem(ScrollCalculatorHelper.this.getPlayListItem(articleInfo));
                        if (TextUtils.isEmpty((CharSequence)videoItemView.getPlayListItem().getPlayVideoUrl())) {
                            YLog.error((Object)"ListVideo", (String)("url is empty!! " + articleInfo.id + " / " + articleInfo.title));
                            return;
                        }
                        videoItemView.setVideoEventListener(ScrollCalculatorHelper.this.mVideoEventListener);
                        videoItemView.playVideo(lastPlayPosition);
                    }
                }
            }, 300L);
        }
    }

    private ListVideoPlayItem getPlayListItem(ArticleInfo articleInfo) {
        VideoDefinition videoDefinition;
        ListVideoPlayItem playListItem = new ListVideoPlayItem();
        if (!TextUtils.isEmpty((CharSequence)articleInfo.getHdUrl())) {
            videoDefinition = new VideoDefinition(1, articleInfo.getHdUrl());
            playListItem.addSupportVideoDefinition(videoDefinition);
        }
        if (!TextUtils.isEmpty((CharSequence)articleInfo.getSdUrl())) {
            videoDefinition = new VideoDefinition(3, articleInfo.getSdUrl());
            playListItem.addSupportVideoDefinition(videoDefinition);
        }
        if (!TextUtils.isEmpty((CharSequence)articleInfo.getMdUrl())) {
            videoDefinition = new VideoDefinition(2, articleInfo.getMdUrl());
            playListItem.addSupportVideoDefinition(videoDefinition);
        }
        playListItem.setName("" + articleInfo.id);
        return playListItem;
    }

    private void pauseVideo(@NotNull ListVideoItemView videoItemView) {
        if (videoItemView.isPlaying()) {
            videoItemView.pauseVideo();
            this.onVideoPlayStop(videoItemView);
        }
    }

    private void stopPlayVideo(ListVideoItemView videoItemView) {
        if (videoItemView.isPlaying()) {
            this.onVideoPlayStop(videoItemView);
            videoItemView.stopVideo();
        }
    }

    private void onVideoPlayStop(ListVideoItemView videoItemView) {
        this.setDefaultVideoImageViewVisible(videoItemView, true);
        videoItemView.setVisibility(8);
        long playPosition = videoItemView.getPlayPosition();
        if (videoItemView.getTag() != null) {
            ArticleInfo articleInfo = (ArticleInfo)videoItemView.getTag();
            this.videoPlayPositionCache.put(articleInfo.id, playPosition);
        }
    }

    private void setDefaultVideoImageViewVisible(ListVideoItemView videoItemView, boolean visible) {
        if (videoItemView.getParent() != null) {
            View parentView = (View)videoItemView.getParent();
            Group defaultVideoView = (Group)parentView.findViewById(R.id.default_video_view);
            if (visible) {
                defaultVideoView.setVisibility(0);
            } else {
                defaultVideoView.setVisibility(8);
            }
        }
    }

    public long getPlayPositionByArticleId(long id2) {
        if (this.videoPlayPositionCache.containsKey(id2)) {
            return this.videoPlayPositionCache.get(id2);
        }
        return 0L;
    }

    public void pauseVideo() {
        ListVideoItemView lastVideoItemView = this.mLastVideoItemView;
        if (lastVideoItemView != null) {
            this.pauseVideo(lastVideoItemView);
        }
    }
}

