/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.util;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.edu24.data.DataApiFactory;
import com.edu24.data.server.upload.UploadPartRes;
import com.edu24.data.server.upload.entity.UploadPartBean;
import com.edu24ol.newclass.discover.util.IHandleUploadVideo;
import com.edu24ol.newclass.discover.util.MD5Utils;
import com.edu24ol.newclass.discover.util.PartUploader;
import com.google.gson.Gson;
import com.hqwx.android.platform.exception.HqException;
import com.hqwx.android.platform.server.BaseRes;
import com.yy.android.educommon.log.YLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.FuncN;
import rx.schedulers.Schedulers;

public class MultipartUploadUtil {
    public static final long perPartSize = 0x500000L;
    public static final int MAX_THREAD = 10;
    public static final long TIME_STAMP = System.currentTimeMillis();
    private static HashMap<String, Pair<String, String>> mInitHashMap = new HashMap();
    private static HashMap<PartUploader, UploadPartBean> mPartUploadHashMap = new HashMap();
    private static HashMap<String, String> mFinishMap = new HashMap();

    public static String getUploadFileName(String videoPath) {
        String fileExtension = MultipartUploadUtil.getFileExtensionFromUrl(videoPath);
        return MD5Utils.getMD5(videoPath + TIME_STAMP) + fileExtension;
    }

    public static String getFileExtensionFromUrl(String fileName) {
        int dotPos;
        if (!TextUtils.isEmpty((CharSequence)fileName) && !fileName.isEmpty() && 0 <= (dotPos = fileName.lastIndexOf(46))) {
            return fileName.substring(dotPos);
        }
        return "";
    }

    public static boolean isNeedPart(long partSize) {
        return partSize > 0x500000L;
    }

    public static void handleUploadVideo(final String passport, final String videoFilePath, final IHandleUploadVideo.UploadListener uploadListener) {
        final String uploadFileName = MultipartUploadUtil.getUploadFileName(videoFilePath);
        YLog.info((Object)"this", (String)("keepon handleUploadVideo " + uploadFileName));
        final String uploadVideoUrl = mFinishMap.get(uploadFileName);
        if (TextUtils.isEmpty((CharSequence)uploadVideoUrl)) {
            MultipartUploadUtil.upLoadVideoInit(passport, uploadFileName, new UploadInitListener(){

                @Override
                public void onInitSuccess(String uploadId, String preVideoUrl) {
                    Observable stringObservable = MultipartUploadUtil.uploadVideo(preVideoUrl, passport, videoFilePath, uploadFileName, uploadId);
                    uploadListener.onUploadSuccess((Observable<String>)stringObservable);
                }

                @Override
                public void onCreateSubscription(Subscription subscription) {
                    uploadListener.onCreateSubscription(subscription);
                }

                @Override
                public void onInitFailed(Throwable throwable) {
                    YLog.error((Object)this, (String)"keepon onInitFailed ", (Throwable)throwable);
                    uploadListener.onFailed(throwable);
                }
            });
        } else {
            uploadListener.onUploadSuccess((Observable<String>)Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

                public void call(Subscriber<? super String> subscriber) {
                    YLog.info((Object)this, (String)"keepon call \u6587\u4ef6\u5df2\u7ecf\u4e0a\u4f20\u8fc7");
                    subscriber.onNext((Object)uploadVideoUrl);
                    subscriber.onCompleted();
                }
            }));
        }
    }

    public static void upLoadVideoInit(String passport, String uploadFileName, UploadInitListener uploadInitListener) {
        Pair<String, String> cachePair = mInitHashMap.get(uploadFileName);
        if (cachePair != null && cachePair.first != null && cachePair.second != null) {
            uploadInitListener.onInitSuccess((String)cachePair.first, (String)cachePair.second);
            YLog.info((Object)"this", (String)("keepon upLoadVideoInit \u5df2\u7ecf\u521d\u59cb\u5316\u8fc7 " + uploadFileName));
        } else {
            Subscription subscribe = DataApiFactory.getInstance().getUploadJApi().multipartInit(passport, uploadFileName, 1).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(uploadPartInitRes -> {
                if (uploadPartInitRes.isSuccessful() && uploadPartInitRes.getData() != null && !TextUtils.isEmpty((CharSequence)uploadPartInitRes.getData().getUploadId())) {
                    String uploadId = uploadPartInitRes.getData().getUploadId();
                    String videoUrl = uploadPartInitRes.getData().getUrl();
                    mInitHashMap.put(uploadFileName, (Pair<String, String>)new Pair((Object)uploadId, (Object)videoUrl));
                    uploadInitListener.onInitSuccess(uploadId, videoUrl);
                } else {
                    uploadInitListener.onInitFailed((Throwable)uploadPartInitRes.getHqException());
                }
            }, uploadInitListener::onInitFailed);
            uploadInitListener.onCreateSubscription(subscribe);
        }
    }

    private static Observable<String> uploadVideo(final String preVideoUrl, final String passport, String videoPath, final String uploadFileName, final String uploadId) {
        List<Observable<UploadPartBean>> videoObservables = MultipartUploadUtil.uploadMulti(passport, videoPath, uploadFileName, uploadId);
        return Observable.zip(videoObservables, (FuncN)new FuncN<String>(){

            public String call(Object ... args) {
                ArrayList<UploadPartBean> uploadPartBeans = new ArrayList<UploadPartBean>();
                if (args != null && args.length > 0) {
                    for (Object arg : args) {
                        if (!(arg instanceof UploadPartBean)) continue;
                        uploadPartBeans.add((UploadPartBean)arg);
                    }
                }
                Gson gson = new Gson();
                String partETags = gson.toJson(uploadPartBeans);
                String videoUrl = null;
                try {
                    BaseRes body = (BaseRes)DataApiFactory.getInstance().getUploadJApi().multipartComplete(passport, uploadId, uploadFileName, partETags).execute().body();
                    if (body != null) {
                        if (body.isSuccessful()) {
                            videoUrl = preVideoUrl;
                            MultipartUploadUtil.onUploadSuccess(uploadFileName, videoUrl);
                        } else {
                            YLog.error((Object)this, (String)"keepon call uploadVideo failed", (Throwable)body.getHqException());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return videoUrl;
            }
        }).subscribeOn(Schedulers.io());
    }

    public static void onUploadSuccess(String uploadFileName, String videoPath) {
        mInitHashMap.remove(uploadFileName);
        mPartUploadHashMap.clear();
        mFinishMap.put(uploadFileName, videoPath);
    }

    public static List<Observable<UploadPartBean>> uploadMulti(String passport, String filePath, String uploadFileName, String uploadId) {
        File file = new File(filePath);
        long partSize = 0x500000L;
        long fileLength = file.length();
        int partCount = (int)(fileLength / partSize);
        if (partCount > 10) {
            YLog.info((Object)"this", (String)"keepon uploadMulti \u8d85\u8fc78\u4e2a\u7ebf\u7a0b\u4e86 ");
            partCount = 10;
            partSize = fileLength / (long)partCount;
        }
        if (fileLength % partSize != 0L) {
            ++partCount;
        }
        ArrayList<Observable<UploadPartBean>> uploadObservableList = new ArrayList<Observable<UploadPartBean>>();
        for (int i = 0; i < partCount; ++i) {
            long startPos = (long)i * partSize;
            long curPartSize = i + 1 == partCount ? fileLength - startPos : partSize;
            Observable<UploadPartBean> videoObservable = MultipartUploadUtil.createVideoObservable(passport, new PartUploader(filePath, uploadFileName, startPos, curPartSize, i + 1, uploadId));
            uploadObservableList.add(videoObservable);
        }
        return uploadObservableList;
    }

    public static Observable<UploadPartBean> createVideoObservable(final String passport, final PartUploader partUploader) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<UploadPartBean>(){

            public void call(Subscriber<? super UploadPartBean> subscriber) {
                try {
                    UploadPartBean uploadPartBean = (UploadPartBean)mPartUploadHashMap.get(partUploader);
                    if (uploadPartBean == null) {
                        uploadPartBean = MultipartUploadUtil.uploadMultiPartSyn(passport, partUploader);
                        mPartUploadHashMap.put(partUploader, uploadPartBean);
                        YLog.info((Object)this, (String)("keepon call \u5206\u7247\u4e0a\u4f20\u6210\u529f " + partUploader.getPartNumber()));
                    } else {
                        YLog.info((Object)this, (String)("keepon call \u4ece\u7f13\u5b58\u83b7\u53d6 " + partUploader.getPartNumber()));
                    }
                    subscriber.onNext((Object)uploadPartBean);
                    subscriber.onCompleted();
                }
                catch (Exception e) {
                    subscriber.onError((Throwable)new HqException("call upload api error:" + e.getMessage()));
                }
            }
        }).subscribeOn(Schedulers.io());
    }

    public static UploadPartBean uploadMultiPartSyn(String passport, PartUploader partUploader) throws Exception {
        String filePath = partUploader.getFilePath();
        MultipartBody.Builder builder = new MultipartBody.Builder().addFormDataPart("passport", passport);
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new RuntimeException("imagePath can not empty or null!");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RuntimeException("file not exist!");
        }
        String fileName = partUploader.getUploadFileName();
        builder.addFormDataPart("file", fileName, MultipartUploadUtil.create(MediaType.parse((String)"application/octet-stream"), file, partUploader));
        UploadPartRes uploadFileRes = (UploadPartRes)DataApiFactory.getInstance().getUploadJApi().multipartUpload(builder.build(), fileName, passport, (long)partUploader.getPartNumber(), partUploader.getPartSize(), partUploader.getUploadId()).execute().body();
        if (uploadFileRes == null) {
            throw new RuntimeException("upload failed");
        }
        if (uploadFileRes.isSuccessful() && uploadFileRes.getData() != null) {
            return uploadFileRes.getData();
        }
        throw uploadFileRes.getHqException();
    }

    public static RequestBody create(final MediaType contentType, final File file, final PartUploader partUploader) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return new RequestBody(){

            @Nullable
            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return partUploader.getPartSize();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source((File)file);
                    BufferedSource bufferedSource = Okio.buffer((Source)source);
                    long offset = partUploader.getStartPos();
                    if (offset > 0L) {
                        bufferedSource.skip(offset);
                    }
                    long partSize = partUploader.getPartSize();
                    YLog.info((Object)((Object)this), (String)("keepon \u5f00\u59cb\u8bfb\u53d6 writeTo " + partUploader.getPartNumber()));
                    sink.write((Source)bufferedSource, partSize);
                    YLog.debug((Object)((Object)this), (String)("keepon \u8bfb\u53d6\u5b8c\u6bd5  " + partUploader.getPartNumber()));
                }
                finally {
                    Util.closeQuietly((Closeable)source);
                }
            }
        };
    }

    static interface UploadInitListener {
        public void onInitSuccess(String var1, String var2);

        public void onCreateSubscription(Subscription var1);

        public void onInitFailed(Throwable var1);
    }
}

