/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.util;

import android.graphics.Point;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.SparseIntArray;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.edu24ol.newclass.discover.util.ItemExposureReportApi;
import java.lang.ref.WeakReference;

public class ItemExposureReportHelper
implements ItemExposureReportApi {
    private SparseIntArray mExposureData = new SparseIntArray();
    protected HandlerThread mHandlerThread;
    protected MyHandler mHandler;
    protected int mOldFirstCompleteVisiblePos = -1;
    protected int mOldLastCompleteVisiblePos = -1;
    protected RecyclerView mRecyclerView;
    private static final int WHAT_TOUCH = 0;
    protected static final int WHAT_RESUME = 1;

    public ItemExposureReportHelper(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.mHandlerThread = new HandlerThread("ItemExposureReportHelper");
        this.mHandlerThread.start();
        this.mHandler = new MyHandler(this.mHandlerThread.getLooper(), this);
    }

    @Override
    public void reset() {
        this.mExposureData.clear();
        this.mOldFirstCompleteVisiblePos = -1;
        this.mOldLastCompleteVisiblePos = -1;
    }

    @Override
    public void release() {
        this.mExposureData.clear();
        this.mHandler.getLooper().quit();
        this.mHandlerThread.quit();
        this.mOldFirstCompleteVisiblePos = -1;
        this.mOldLastCompleteVisiblePos = -1;
    }

    @Override
    public SparseIntArray getData() {
        return this.mExposureData;
    }

    @Override
    public void onResume() {
        this.mHandler.sendEmptyMessage(1);
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int scrollState) {
        switch (scrollState) {
            case 0: {
                this.statExposureViews();
                break;
            }
        }
    }

    private void statExposureViews() {
        this.mHandler.sendEmptyMessage(0);
    }

    protected void recordTouch() {
        Point visiblePosition = this.findRangePosition();
        if (visiblePosition == null) {
            return;
        }
        int firstCompleteVisiblePos = visiblePosition.x;
        int lastCompleteVisiblePos = visiblePosition.y;
        if (firstCompleteVisiblePos == this.mOldFirstCompleteVisiblePos && lastCompleteVisiblePos == this.mOldLastCompleteVisiblePos) {
            return;
        }
        if (this.mOldFirstCompleteVisiblePos == -1 || firstCompleteVisiblePos > this.mOldLastCompleteVisiblePos || lastCompleteVisiblePos < this.mOldFirstCompleteVisiblePos) {
            for (int i = firstCompleteVisiblePos; i <= lastCompleteVisiblePos; ++i) {
                this.addData(i);
            }
        } else {
            int i;
            if (firstCompleteVisiblePos < this.mOldFirstCompleteVisiblePos) {
                for (i = firstCompleteVisiblePos; i < this.mOldFirstCompleteVisiblePos; ++i) {
                    this.addData(i);
                }
            }
            if (lastCompleteVisiblePos > this.mOldLastCompleteVisiblePos) {
                for (i = this.mOldLastCompleteVisiblePos + 1; i <= lastCompleteVisiblePos; ++i) {
                    this.addData(i);
                }
            }
        }
        this.mOldFirstCompleteVisiblePos = firstCompleteVisiblePos;
        this.mOldLastCompleteVisiblePos = lastCompleteVisiblePos;
    }

    protected void recordResume() {
        Point visiblePosition = this.findRangePosition();
        if (visiblePosition == null) {
            return;
        }
        int firstCompleteVisiblePos = visiblePosition.x;
        int lastCompleteVisiblePos = visiblePosition.y;
        for (int i = firstCompleteVisiblePos; i <= lastCompleteVisiblePos; ++i) {
            this.addData(i);
        }
    }

    private void addData(int position) {
        int count = this.mExposureData.get(position);
        this.mExposureData.put(position, count + 1);
    }

    private Point findRangePosition() {
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)this.mRecyclerView.getLayoutManager();
        int firstCompleteVisiblePosition = -1;
        int lastCompleteVisiblePosition = -1;
        try {
            firstCompleteVisiblePosition = linearLayoutManager.findFirstCompletelyVisibleItemPosition();
            lastCompleteVisiblePosition = linearLayoutManager.findLastCompletelyVisibleItemPosition();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (firstCompleteVisiblePosition == -1) {
            return null;
        }
        return new Point(firstCompleteVisiblePosition, lastCompleteVisiblePosition);
    }

    protected static class MyHandler
    extends Handler {
        private WeakReference<ItemExposureReportHelper> mReference;

        private MyHandler(Looper looper, ItemExposureReportHelper refrence) {
            super(looper);
            this.mReference = new WeakReference<ItemExposureReportHelper>(refrence);
        }

        public void handleMessage(Message msg) {
            ItemExposureReportHelper itemExposureReportHelper = (ItemExposureReportHelper)this.mReference.get();
            switch (msg.what) {
                case 0: {
                    if (itemExposureReportHelper == null) break;
                    itemExposureReportHelper.recordTouch();
                    break;
                }
                case 1: {
                    if (itemExposureReportHelper == null) break;
                    itemExposureReportHelper.recordResume();
                    break;
                }
            }
        }
    }
}

