/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.util;

import android.graphics.Color;
import android.text.Spannable;
import android.text.style.ForegroundColorSpan;
import com.edu24.data.server.discover.entity.ArticleATUser;
import com.edu24.data.server.discover.entity.ArticleTopic;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.edu24ol.newclass.discover.text.TopicClickableSpan;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiscoverSpanStringUtil {
    public static void setStringArticleTopicHighlight(Spannable spannable, List<ArticleTopic> topics) {
        if (topics != null && topics.size() > 0) {
            for (ArticleTopic articleTopic : topics) {
                Pattern pattern = Pattern.compile("#" + articleTopic.getTopicName() + "#");
                Matcher matcher = pattern.matcher(spannable.toString());
                while (matcher.find()) {
                    spannable.setSpan((Object)new TopicClickableSpan(articleTopic.getId()), matcher.start(), matcher.end(), 34);
                }
            }
        }
    }

    public static void setArticleTopicOnlyHighlight(Spannable spannable, List<ArticleTopic> topics) {
        if (topics != null && topics.size() > 0) {
            for (ArticleTopic articleTopic : topics) {
                Pattern pattern = Pattern.compile("#" + articleTopic.getTopicName() + "#");
                Matcher matcher = pattern.matcher(spannable.toString());
                while (matcher.find()) {
                    spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#FF3965BC")), matcher.start(), matcher.end(), 34);
                }
            }
        }
    }

    public static void setStringArticleUserHighlight(Spannable spannable, List<ArticleATUser> users) {
        if (users != null && users.size() > 0) {
            for (ArticleATUser articleATUser : users) {
                Pattern pattern = Pattern.compile("@" + articleATUser.getNickName());
                Matcher matcher = pattern.matcher(spannable.toString());
                while (matcher.find()) {
                    spannable.setSpan((Object)new AtUserClickableSpan(articleATUser.getUid()), matcher.start(), matcher.end(), 34);
                }
            }
        }
    }

    public static void setArticleUserOnlyHighlight(Spannable spannable, List<ArticleATUser> users) {
        if (users != null && users.size() > 0) {
            for (ArticleATUser articleATUser : users) {
                Pattern pattern = Pattern.compile("@" + articleATUser.getNickName());
                Matcher matcher = pattern.matcher(spannable.toString());
                while (matcher.find()) {
                    spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#FF3965BC")), matcher.start(), matcher.end(), 34);
                }
            }
        }
    }
}

