/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.presenter;

import com.edu24.data.DataApiFactory;
import com.edu24.data.server.discover.DiscoverDataApiFactory;
import com.edu24.data.server.response.BooleanRes;
import com.edu24ol.newclass.discover.presenter.IDiscoverArticlePresenter;
import com.hqwx.android.platform.exception.HqException;
import com.hqwx.android.platform.server.BaseRes;
import com.hqwx.android.service.ServiceFactory;
import com.yy.android.educommon.log.YLog;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public class DiscoverArticlePresenter
implements IDiscoverArticlePresenter {
    private IDiscoverArticlePresenter.IDiscoverArticleView mDiscoverArticleView;

    public DiscoverArticlePresenter(IDiscoverArticlePresenter.IDiscoverArticleView discoverArticleView) {
        this.mDiscoverArticleView = discoverArticleView;
    }

    @Override
    public void handleArticleLikeState(final boolean isToLike, long articleId, final int handlePosition) {
        Observable observable = null;
        observable = isToLike ? DiscoverDataApiFactory.getInstance().getDiscoverApi().likeArticle(ServiceFactory.getAccountService().getHqToken(), articleId) : DiscoverDataApiFactory.getInstance().getDiscoverApi().unLikeArticle(ServiceFactory.getAccountService().getHqToken(), articleId);
        this.mDiscoverArticleView.getCompositeSubscription().add(observable.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<BaseRes>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                YLog.error((Object)((Object)this), (Throwable)e);
            }

            public void onNext(BaseRes baseRes) {
                if (baseRes.isSuccessful()) {
                    DiscoverArticlePresenter.this.mDiscoverArticleView.onHandlerArticleLikeStateSuccess(isToLike, handlePosition);
                }
            }
        }));
    }

    @Override
    public void deleteArticle(String token, final long articleId) {
        if (this.mDiscoverArticleView != null && this.mDiscoverArticleView.getCompositeSubscription() != null) {
            this.mDiscoverArticleView.getCompositeSubscription().add(DataApiFactory.getInstance().getDiscoverjApi().deleteContent(token, articleId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<BooleanRes>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    if (DiscoverArticlePresenter.this.mDiscoverArticleView != null) {
                        DiscoverArticlePresenter.this.mDiscoverArticleView.onDeleteArticleFailure(e, articleId);
                    }
                }

                public void onNext(BooleanRes baseRes) {
                    if (DiscoverArticlePresenter.this.mDiscoverArticleView != null) {
                        if (baseRes.isSuccessful()) {
                            DiscoverArticlePresenter.this.mDiscoverArticleView.onDeleteArticleSuccess(articleId);
                        } else {
                            DiscoverArticlePresenter.this.mDiscoverArticleView.onDeleteArticleFailure((Throwable)new HqException(baseRes.getMessage()), articleId);
                        }
                    }
                }
            }));
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

