/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.presenter;

import com.edu24.data.server.discover.DiscoverDataApiFactory;
import com.edu24ol.newclass.discover.presenter.IAuthorFollowActionPresenter;
import com.edu24ol.newclass.discover.presenter.ui.IAuthorFollowUI;
import com.hqwx.android.platform.exception.HqException;
import com.hqwx.android.platform.server.BaseRes;
import com.yy.android.educommon.log.YLog;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.schedulers.Schedulers;

public class AuthorFollowActionPresenter
implements IAuthorFollowActionPresenter {
    private IAuthorFollowUI mUIController;

    public AuthorFollowActionPresenter(IAuthorFollowUI articleFollowUI) {
        this.mUIController = articleFollowUI;
    }

    @Override
    public void followAuthor(String token, final long authorId) {
        if (this.mUIController != null && this.mUIController.getCompositeSubscription() != null) {
            this.mUIController.getCompositeSubscription().add(DiscoverDataApiFactory.getInstance().getDiscoverApi().followAuthor(token, authorId).subscribeOn(Schedulers.io()).doOnSubscribe(new Action0(){

                public void call() {
                    AuthorFollowActionPresenter.this.mUIController.showLoadingDialog();
                }
            }).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<BaseRes>(){

                public void onCompleted() {
                    AuthorFollowActionPresenter.this.mUIController.dismissLoadingDialog();
                }

                public void onError(Throwable e) {
                    AuthorFollowActionPresenter.this.mUIController.dismissLoadingDialog();
                    AuthorFollowActionPresenter.this.mUIController.onFollowAuthorFail(e);
                    YLog.error((Object)"", (Throwable)e);
                }

                public void onNext(BaseRes response) {
                    if (response != null && response.isSuccessful()) {
                        AuthorFollowActionPresenter.this.mUIController.onFollowAuthorSuccess(authorId);
                    } else {
                        AuthorFollowActionPresenter.this.mUIController.onFollowAuthorFail((Throwable)new HqException(response.getMessage()));
                    }
                }
            }));
        }
    }

    @Override
    public void unFollowAuthor(String token, final long authorId) {
        if (this.mUIController != null && this.mUIController.getCompositeSubscription() != null) {
            this.mUIController.getCompositeSubscription().add(DiscoverDataApiFactory.getInstance().getDiscoverApi().unFollowAuthor(token, authorId).subscribeOn(Schedulers.io()).doOnSubscribe(new Action0(){

                public void call() {
                    AuthorFollowActionPresenter.this.mUIController.showLoadingDialog();
                }
            }).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<BaseRes>(){

                public void onCompleted() {
                    AuthorFollowActionPresenter.this.mUIController.dismissLoadingDialog();
                }

                public void onError(Throwable e) {
                    AuthorFollowActionPresenter.this.mUIController.dismissLoadingDialog();
                    AuthorFollowActionPresenter.this.mUIController.onUnFollowAuthorFail(e);
                    YLog.error((Object)"", (Throwable)e);
                }

                public void onNext(BaseRes response) {
                    if (response != null && response.isSuccessful()) {
                        AuthorFollowActionPresenter.this.mUIController.onUnFollowAuthorSuccess(authorId);
                    } else {
                        AuthorFollowActionPresenter.this.mUIController.onUnFollowAuthorFail((Throwable)new HqException(response.getMessage()));
                    }
                }
            }));
        }
    }
}

