/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.home.recommend;

import android.content.Context;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.edu24.data.server.discover.entity.HomeDiscoverArticleItemBean;
import com.edu24ol.newclass.discover.adapter.DiscoverBaseArticleListAdapter;
import com.hqwx.android.discover.common.R;

public class HomeDiscoverRecommendListAdapter
extends DiscoverBaseArticleListAdapter {
    public OnHomeDiscoverItemClickListener mOnHomeDiscoverItemClickListener;

    public void setOnHomeDiscoverItemClickListener(OnHomeDiscoverItemClickListener onHomeDiscoverItemClickListener) {
        this.mOnHomeDiscoverItemClickListener = onHomeDiscoverItemClickListener;
    }

    public HomeDiscoverRecommendListAdapter(Context context) {
        super(context);
    }

    @Override
    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        if (i == -1) {
            return new DiscoverLastReadViewHolder(this.initItemLayoutInflater(viewGroup, R.layout.discover_item_recommend_last_read_layout));
        }
        return super.onCreateViewHolder(viewGroup, i);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        if (viewHolder instanceof DiscoverLastReadViewHolder) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (HomeDiscoverRecommendListAdapter.this.mOnHomeDiscoverItemClickListener != null) {
                        HomeDiscoverRecommendListAdapter.this.mOnHomeDiscoverItemClickListener.onLastRecordLearnClick();
                    }
                }
            });
        } else {
            super.onBindViewHolder(viewHolder, i);
        }
    }

    @Override
    public int getItemViewType(int position) {
        if (!this.mIsHaveLastRead) {
            return super.getItemViewType(position);
        }
        if (this.mRefreshDataCount == position) {
            return -1;
        }
        return super.getItemViewType(position);
    }

    public HomeDiscoverArticleItemBean getItem(int position) {
        if (this.mIsHaveLastRead && position > this.mRefreshDataCount) {
            return (HomeDiscoverArticleItemBean)super.getItem(position - 1);
        }
        return (HomeDiscoverArticleItemBean)super.getItem(position);
    }

    public int getItemCount() {
        if (this.mIsHaveLastRead) {
            return super.getItemCount() + 1;
        }
        return super.getItemCount();
    }

    @Override
    public boolean isShowAttention() {
        return true;
    }

    @Override
    public boolean isShowMoreButton() {
        return true;
    }

    protected class DiscoverLastReadViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mLastReadView;

        public DiscoverLastReadViewHolder(View itemView) {
            super(itemView);
            this.mLastReadView = (TextView)itemView.findViewById(R.id.item_recommend_last_read_view);
            SpannableString spannableString = new SpannableString((CharSequence)HomeDiscoverRecommendListAdapter.this.mContext.getString(R.string.discover_last_read_notice));
            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(HomeDiscoverRecommendListAdapter.this.mContext.getResources().getColor(R.color.primary_blue));
            spannableString.setSpan((Object)foregroundColorSpan, 7, 11, 34);
            this.mLastReadView.setText((CharSequence)spannableString);
        }
    }

    public static interface OnHomeDiscoverItemClickListener {
        public void onLastRecordLearnClick();
    }
}

