/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.edu24ol.newclass.discover.adapter.LoadMorelAdapter;
import com.edu24ol.newclass.discover.base.DiscoverBaseFragment;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.model.Visitable;
import com.hqwx.android.platform.mvp.BaseLoadMorePresenter;
import com.hqwx.android.platform.mvp.IGetPageDataMvpView;
import com.hqwx.android.platform.mvp.MvpView;
import com.hqwx.android.platform.utils.ToastUtil;
import com.hqwx.android.platform.widgets.LoadingDataStatusView;
import com.hqwx.android.platform.widgets.pullrefresh.HqwxRefreshLayout;
import com.hqwx.android.platform.widgets.pullrefresh.listener.OnRefreshLoadMoreListener;
import com.yy.android.educommon.log.YLog;
import com.yy.android.educommon.utils.NetworkUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BaseLoadMoreFragment<P extends BaseLoadMorePresenter, T, M extends Visitable>
extends DiscoverBaseFragment
implements IGetPageDataMvpView<T> {
    private static final String TAG = "BaseLoadMoreFragment";
    protected RecyclerView mRecyclerView;
    protected HqwxRefreshLayout mHqwxRefreshLayout;
    P mPresenter;
    protected LoadMorelAdapter mAdapter;
    protected long mUid;
    private OnRefreshLoadMoreListener mOnRefreshLoadMoreListener = new OnRefreshLoadMoreListener(){

        public void onLoadMore(HqwxRefreshLayout refreshLayout) {
            if (NetworkUtil.isNetworkAvailable((Context)BaseLoadMoreFragment.this.getActivity())) {
                BaseLoadMoreFragment.this.mPresenter.getNextPageList(false);
            } else {
                ToastUtil.showMessage((Context)BaseLoadMoreFragment.this.getActivity(), (CharSequence)BaseLoadMoreFragment.this.getString(R.string.network_not_available));
                refreshLayout.finishLoadMore();
            }
        }

        public void onRefresh(HqwxRefreshLayout refreshLayout) {
            if (NetworkUtil.isNetworkAvailable((Context)BaseLoadMoreFragment.this.getActivity())) {
                BaseLoadMoreFragment.this.refreshData(false);
            } else {
                ToastUtil.showMessage((Context)BaseLoadMoreFragment.this.getActivity(), (CharSequence)BaseLoadMoreFragment.this.getString(R.string.network_not_available));
                refreshLayout.finishRefresh();
            }
        }
    };

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.discover_common_fragment_base_load_more, null);
        this.getFragmentArguments(this.getArguments());
        this.initView(view);
        this.initEvent();
        this.refreshData(false);
        return view;
    }

    protected void getFragmentArguments(Bundle bundle) {
        if (bundle != null) {
            this.mUid = bundle.getLong("intent_uid");
        }
    }

    private void initView(View view) {
        this.mHqwxRefreshLayout = (HqwxRefreshLayout)view.findViewById(R.id.refresh_layout);
        this.mRecyclerView = this.mHqwxRefreshLayout.getRecyclerView();
        this.mLoadingStatusView = (LoadingDataStatusView)view.findViewById(R.id.status_view);
        this.mLoadingStatusView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseLoadMoreFragment.this.refreshData(false);
            }
        });
        this.mHqwxRefreshLayout.setOnRefreshLoadMoreListener(this.mOnRefreshLoadMoreListener);
        this.mHqwxRefreshLayout.setEnableRefresh(false);
        this.mHqwxRefreshLayout.setEnableLoadMore(false);
        RecyclerView.ItemDecoration itemItemDecoration = this.getItemItemDecoration();
        if (itemItemDecoration != null) {
            this.mRecyclerView.addItemDecoration(this.getItemItemDecoration());
        }
        this.mAdapter = this.getAdapter();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mPresenter = this.getDataPresenter();
        this.mPresenter.onAttach((MvpView)this);
    }

    @NotNull
    protected LoadMorelAdapter getAdapter() {
        return new LoadMorelAdapter((Context)this.getActivity());
    }

    protected void initEvent() {
    }

    protected void setRecyclerViewMarginTop(int marginTop) {
        if (this.mRecyclerView != null) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRecyclerView.getLayoutParams();
            if (layoutParams == null) {
                layoutParams = new ViewGroup.MarginLayoutParams(-1, -1);
            }
            layoutParams.topMargin = marginTop;
        }
    }

    protected RecyclerView.ItemDecoration getItemItemDecoration() {
        return null;
    }

    public Class getGenericModelClass(Class clazz) {
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type parameterArgType : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                Class parameterArgClass = (Class)parameterArgType;
                if (!Visitable.class.isAssignableFrom(parameterArgClass)) continue;
                return parameterArgClass;
            }
        }
        return null;
    }

    public Class getGenericTClass(Class clazz) {
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type parameterArgType : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                Class parameterArgClass = (Class)parameterArgType;
                if (Visitable.class.isAssignableFrom(parameterArgClass) || BaseLoadMorePresenter.class.isAssignableFrom(parameterArgClass)) continue;
                return parameterArgClass;
            }
        }
        return null;
    }

    protected abstract P getDataPresenter();

    public void refreshData(boolean showLoadingDialog) {
        this.mPresenter.getRefreshList(showLoadingDialog);
    }

    protected void setNoDataView() {
        this.mLoadingStatusView.showEmptyView("\u6682\u65e0\u5185\u5bb9");
    }

    protected void setErrorView(Throwable e) {
        this.mLoadingStatusView.showErrorViewByThrowable(e);
    }

    public boolean isActive() {
        return this.isAdded();
    }

    public void onRefreshListData(List<T> data, boolean isNoMore) {
        this.mLoadingStatusView.setVisibility(8);
        this.mHqwxRefreshLayout.setEnableRefresh(true);
        this.mHqwxRefreshLayout.finishRefresh();
        this.mHqwxRefreshLayout.setEnableLoadMore(true);
        this.mAdapter.setData(this.onGetListVisitableData(data));
        this.mAdapter.notifyDataSetChanged();
        if (isNoMore) {
            this.handleNoMoreData(true);
        }
    }

    protected List<Visitable> onGetListVisitableData(List<T> list) {
        if (list != null && list.size() > 0) {
            ArrayList<Visitable> datas = new ArrayList<Visitable>();
            Class modleClass = null;
            Class tClass = null;
            Constructor declaredConstructor = null;
            for (T data : list) {
                try {
                    Object o;
                    if (modleClass == null) {
                        modleClass = this.getGenericModelClass(((Object)((Object)this)).getClass());
                    }
                    if (tClass == null) {
                        tClass = this.getGenericTClass(((Object)((Object)this)).getClass());
                        declaredConstructor = modleClass.getDeclaredConstructor(tClass);
                        declaredConstructor.setAccessible(true);
                    }
                    if (!((o = declaredConstructor.newInstance(data)) instanceof Visitable)) continue;
                    datas.add((Visitable)o);
                }
                catch (Exception e) {
                    YLog.error((Object)((Object)this), (String)"BaseLoadMoreFragment onGetListVisitableData exception", (Throwable)e);
                }
            }
            return datas;
        }
        return null;
    }

    public void onGetMoreListData(List<T> data, boolean isNoMore) {
        this.mAdapter.addData(this.onGetListVisitableData(data));
        this.mAdapter.notifyDataSetChanged();
        if (isNoMore) {
            this.handleNoMoreData(false);
        } else {
            this.mHqwxRefreshLayout.finishLoadMore();
        }
    }

    public void onNoData() {
        this.mHqwxRefreshLayout.handleNoData();
        this.setNoDataView();
    }

    public void showLoadingView() {
        if (this.mAdapter == null || this.mAdapter.isEmpty()) {
            super.showLoadingView();
        }
    }

    public void onError(boolean isRefresh, Throwable e) {
        this.mHqwxRefreshLayout.handleErrorData(isRefresh);
        if (isRefresh) {
            if (this.mAdapter.getDatas() != null && this.mAdapter.getDatas().size() > 0) {
                ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)"\u5237\u65b0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            } else {
                this.setErrorView(e);
            }
        } else if (this.mAdapter.getDatas() != null && this.mAdapter.getDatas().size() > 0) {
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)"\u52a0\u8f7d\u66f4\u591a\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        } else {
            this.setErrorView(e);
        }
    }

    public void onNoMoreData() {
        this.handleNoMoreData(false);
    }

    protected void handleNoMoreData(boolean isFromRefresh) {
        if (isFromRefresh) {
            this.mHqwxRefreshLayout.handleFinishRefreshData(true);
        } else {
            this.mHqwxRefreshLayout.handleFinishLoadMoreData(true);
        }
    }

    public void onDestroy() {
        if (this.mPresenter != null) {
            this.mPresenter.onDetach();
        }
        super.onDestroy();
    }
}

