/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.base;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.edu24.data.DataApiFactory;
import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.discover.entity.HomeDiscoverArticleItemBean;
import com.edu24.data.server.entity.GoodsGroupListBean;
import com.edu24.data.server.integration.share.NotifyShareCreditContract;
import com.edu24.data.server.integration.share.NotifyShareCreditPresenter;
import com.edu24.data.server.integration.share.ShareCrediteRes;
import com.edu24.data.server.wechatsale.entity.OfficialAccountDialogBean;
import com.edu24.data.server.wechatsale.entity.WechatSaleBean;
import com.edu24ol.newclass.discover.adapter.DiscoverBaseArticleListAdapter;
import com.edu24ol.newclass.discover.base.DiscoverBaseFragment;
import com.edu24ol.newclass.discover.presenter.ArticleStatPresenter;
import com.edu24ol.newclass.discover.presenter.DiscoverArticlePresenter;
import com.edu24ol.newclass.discover.presenter.IArticleStatPresenter;
import com.edu24ol.newclass.discover.presenter.IDiscoverArticlePresenter;
import com.edu24ol.newclass.discover.presenter.published.PublishedContract;
import com.edu24ol.newclass.discover.presenter.published.PublishedImpl;
import com.edu24ol.newclass.discover.presenter.ui.IArticleStatMvpView;
import com.edu24ol.newclass.discover.stat.DiscoverStat;
import com.edu24ol.newclass.discover.util.DiscoverRouterUtils;
import com.edu24ol.newclass.discover.util.ItemExposureReportHelper;
import com.edu24ol.newclass.discover.util.ScrollCalculatorHelper;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleEvent;
import com.edu24ol.newclass.discover.widget.DiscoverRecommendItemDecoration;
import com.edu24ol.newclass.discover.widget.DiscoverReportDialog;
import com.ethanhua.skeleton.Skeleton;
import com.ethanhua.skeleton.SkeletonScreen;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.discovershare.OnDiscoverShareImpl;
import com.hqwx.android.platform.AppMessage;
import com.hqwx.android.platform.exception.HqException;
import com.hqwx.android.platform.model.ShareTypeModel;
import com.hqwx.android.platform.mvp.MvpView;
import com.hqwx.android.platform.stat.StatAgent;
import com.hqwx.android.platform.stat.StatParamStorage;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.ToastUtil;
import com.hqwx.android.platform.widgets.CommonDialog;
import com.hqwx.android.platform.widgets.LoadingDataStatusView;
import com.hqwx.android.platform.widgets.pullrefresh.HqwxRefreshLayout;
import com.hqwx.android.service.AppRouter;
import com.hqwx.android.service.ServiceFactory;
import com.hqwx.android.service.difference.DifferenceConfig;
import com.hqwx.android.service.mall.video.MallVideoExtra;
import com.hqwx.android.service.mall.video.MallVideoRouter;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.yy.android.educommon.log.YLog;
import de.greenrobot.event.EventBus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import rx.subscriptions.CompositeSubscription;

public abstract class BaseDiscoverArticleListFragment<A extends DiscoverBaseArticleListAdapter>
extends DiscoverBaseFragment
implements DiscoverArticleEvent.HeaderEventListener,
DiscoverArticleEvent.FooterEventListener,
DiscoverArticleEvent.MoreMenuEventListener,
DiscoverArticleEvent.CommonEventListener,
IDiscoverArticlePresenter.IDiscoverArticleView,
IArticleStatMvpView,
NotifyShareCreditContract.INotifyShareCreditMvpView,
PublishedContract.View {
    private static final String TAG = "BaseDiscoverArticleList";
    protected DiscoverArticlePresenter mDiscoverArticlePresenter;
    protected A mAdapter;
    protected RecyclerView mRecyclerView;
    OnDiscoverShareImpl mOnDiscoverShareImpl;
    protected HqwxRefreshLayout mSmartRefreshLayout;
    protected LoadingDataStatusView mLoadingDataStatusView;
    private SkeletonScreen mSkeletonScreen;
    protected TextView mRefreshNoticeView;
    protected String mIntentIdString;
    protected int mChildFragmentType;
    protected IArticleStatPresenter mArticleStatPresenter;
    public static final int CHILD_RECOMMEND_FRG_TYPE = 1;
    public static final int CHILD_ATTENTION_FRG_TYPE = 2;
    public static final int CHILD_TOPIC_HOT_FRG_TYPE = 3;
    public static final int CHILD_TOPIC_NEW_FRG_TYPE = 4;
    public static final int CHILD_SQUARE_FRG_TYPE = 5;
    public static final int CHILD_AUTHOR_FRG_TYPE = 6;
    public static final int CHILD_LEAVE_WORD_FRG_TYPE = 7;
    private ArticleInfo mShareArticleInfo;
    NotifyShareCreditContract.INotifyShareCreditMvpPresenter mShareCreditMvpPresenter;
    protected long enterTime;
    protected boolean mIsInteractiveState;
    private ScrollCalculatorHelper mScrollCalculatorHelper;
    protected ItemExposureReportHelper mItemExposureReportHelper;
    protected StatParamStorage.StatParams mStatParams;
    protected SharedPreferences.OnSharedPreferenceChangeListener mOnSharedPreferenceChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            if (TextUtils.equals((CharSequence)key, (CharSequence)"key_intent_exam_ids") && ServiceFactory.getAccountService().isLogin()) {
                String newIntentIdString = ServiceFactory.getAppService().getIntentIdString(BaseDiscoverArticleListFragment.this.getContext());
                if (!(TextUtils.isEmpty((CharSequence)BaseDiscoverArticleListFragment.this.mIntentIdString) || TextUtils.isEmpty((CharSequence)newIntentIdString) || BaseDiscoverArticleListFragment.this.mIntentIdString.equals(newIntentIdString))) {
                    BaseDiscoverArticleListFragment.this.mIntentIdString = newIntentIdString;
                    BaseDiscoverArticleListFragment.this.refreshArticleList();
                }
            }
        }
    };
    public List<HomeDiscoverArticleItemBean> mLocalMakeArticleItemBeans;
    protected boolean canLoadMore = true;
    PublishedContract.Presenter<PublishedContract.View> mPublishedPresenter;

    public void setIntentIdString(String intentIdString) {
        this.mIntentIdString = intentIdString;
    }

    public void setStatParams(StatParamStorage.StatParams statParams) {
        this.mStatParams = statParams;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mDiscoverArticlePresenter = new DiscoverArticlePresenter(this);
        this.mArticleStatPresenter = new ArticleStatPresenter();
        this.mArticleStatPresenter.onAttach(this);
        ServiceFactory.getAppService().registerPreferenceChangeListener(this.mOnSharedPreferenceChangeListener);
    }

    protected void initAdapter() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this.getActivity());
        linearLayoutManager.setAutoMeasureEnabled(true);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DiscoverRecommendItemDecoration((Context)this.getActivity(), Color.parseColor((String)"#F4F6F9"), DisplayUtils.dip2px((Context)this.getContext(), (float)7.0f)));
        this.mAdapter = this.getAdapter();
        this.mRecyclerView.setAdapter(this.mAdapter);
        ((DiscoverBaseArticleListAdapter)((Object)this.mAdapter)).setCommonEventListener(this);
        ((DiscoverBaseArticleListAdapter)((Object)this.mAdapter)).setFooterEventListener(this);
        ((DiscoverBaseArticleListAdapter)((Object)this.mAdapter)).setHeaderEventListener(this);
        ((DiscoverBaseArticleListAdapter)((Object)this.mAdapter)).setMoreMenuEventListener(this);
    }

    protected abstract A getAdapter();

    public void onDestroyView() {
        super.onDestroyView();
        this.mArticleStatPresenter.onDetach();
        this.mItemExposureReportHelper.release();
    }

    public void onDestroy() {
        if (this.mShareCreditMvpPresenter != null) {
            this.mShareCreditMvpPresenter.onDetach();
        }
        if (this.mPublishedPresenter != null) {
            this.mPublishedPresenter.onDetach();
        }
        ServiceFactory.getAppService().unregisterPreferenceChangeListener(this.mOnSharedPreferenceChangeListener);
        super.onDestroy();
    }

    @Override
    public void onAuthorInfoClick(ArticleAuthor author) {
        switch (this.getChildFragmentType()) {
            case 1: {
                StatAgent.onEvent((Context)this.getContext(), (String)"Discovery_RecommendedList_clickWriter");
                break;
            }
            case 2: {
                StatAgent.onEvent((Context)this.getContext(), (String)"Discovery_AttentionList_clickWriter");
                break;
            }
        }
        if (author != null) {
            AppRouter.startAuthorDetailAct((Context)this.getActivity(), (long)author.id);
        }
    }

    @Override
    public void onArticleItemClick(ArticleInfo articleInfo) {
        this.onArticleItemClick(articleInfo, this.getBelongSeat());
    }

    @Override
    public void onArticleItemClick(@NonNull @NotNull ArticleInfo articleInfo, @NonNull @NotNull String belongSeat) {
        this.pauseVideo();
        if (articleInfo.contentType == 2) {
            this.handleVideoArticleClick(articleInfo, belongSeat, 0L);
        } else {
            AppRouter.startArticleDetailAct((Context)this.getActivity(), (long)articleInfo.id, (String)this.getBelongPage(), (String)belongSeat, (String)(articleInfo.postion + 1 + ""), (boolean)false, (long)0L);
        }
    }

    private void handleVideoArticleClick(ArticleInfo articleInfo, String belongSeat, long videoStartPlayPosition) {
        if (DifferenceConfig.discoverDifferenceService.isDiscoverVideoJumpToMallVideo()) {
            int secondCategoryId = 0;
            if (this.mIntentIdString != null) {
                try {
                    secondCategoryId = Integer.parseInt(this.mIntentIdString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            MallVideoExtra mallVideoExtra = new MallVideoExtra(articleInfo.id, secondCategoryId, "\u53d1\u73b0\u793e\u533a", belongSeat, String.valueOf(0), 0, 0, 1);
            MallVideoRouter.startMallVideoHome((Context)this.getActivity(), (MallVideoExtra)mallVideoExtra);
        } else {
            DiscoverRouterUtils.startVideoArticleDetail((Context)this.getActivity(), articleInfo.id, false, articleInfo.getSecondCategoryId(), videoStartPlayPosition, 1, -1, this.getBelongPage(), belongSeat, articleInfo.postion + 1 + "", null);
        }
    }

    @Override
    public void onForwardArticleItemClick(@NonNull ArticleInfo articleInfo) {
        this.onArticleItemClick(articleInfo);
    }

    @Override
    public void onRecommendCourseClick(GoodsGroupListBean goodsGroupListBean) {
        if (goodsGroupListBean != null) {
            String belongPage = this.getBelongPage();
            String belongSeat = "\u5185\u5bb9\u8bfe\u7a0b\u63a8\u8350";
            AppRouter.startGoodsCourseDetailAct((Context)this.getActivity(), (int)goodsGroupListBean.id, (String)belongPage, (String)belongSeat);
        } else {
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)"\u63a8\u8350\u8bfe\u7a0b\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @Override
    public void onForwardArticleClick(ArticleInfo articleInfo) {
        this.handleForwardClick(articleInfo);
    }

    @Override
    public void onShareArticleClick(ArticleInfo articleInfo) {
        if (this.mOnDiscoverShareImpl != null && this.mOnDiscoverShareImpl.isShowing()) {
            return;
        }
        this.mShareArticleInfo = articleInfo;
        this.popShareWindow(this.mShareArticleInfo);
        StatAgent.onAppShare((Context)this.getContext(), (String)this.getBelongPage(), (String)"\u8f6c\u53d1", (long)articleInfo.id, (String)articleInfo.getShareStatContent(), (String)"\u94fe\u63a5");
    }

    @Override
    public void onEvaluateArticleClick(ArticleInfo articleInfo) {
        this.pauseVideo();
        if (articleInfo.contentType == 2) {
            this.handleVideoArticleClick(articleInfo, this.getBelongSeat(), this.mScrollCalculatorHelper.getPlayPositionByArticleId(articleInfo.id));
        } else {
            AppRouter.startArticleDetailAct((Context)this.getActivity(), (long)articleInfo.id, (String)this.getBelongPage(), (String)this.getBelongSeat(), (String)(articleInfo.postion + 1 + ""), (boolean)false, (long)0L);
        }
    }

    @Override
    public void onPraiseArticleClick(ArticleInfo articleInfo, int handlePosition) {
        if (!ServiceFactory.getAccountService().isLogin()) {
            AppRouter.startAccountPhoneLogin((Context)this.getActivity());
            return;
        }
        String authorName = "";
        if (articleInfo.author != null) {
            authorName = articleInfo.author.name;
        }
        DiscoverStat.onAppContentLike(this.getContext(), this.getBelongPage(), this.getBelongSeat(), !articleInfo.isLikeArticle(), String.valueOf(articleInfo.id), articleInfo.title, authorName, null, null);
        this.mDiscoverArticlePresenter.handleArticleLikeState(!articleInfo.isLikeArticle(), articleInfo.id, handlePosition);
    }

    @Override
    public void onAttentionClick(CheckBox checkBox, ArticleAuthor author, boolean attention) {
    }

    @Override
    public void onMenuShareClick(@NonNull @NotNull ArticleInfo articleInfo) {
        this.onShareArticleClick(articleInfo);
    }

    @Override
    public void onMenuReportClick(@NonNull @NotNull ArticleInfo articleInfo) {
        DiscoverReportDialog reportDialog = new DiscoverReportDialog((Context)this.getActivity(), articleInfo.id);
        reportDialog.showAtBottom();
    }

    @Override
    public void onMenuDeleteClick(@NonNull @NotNull ArticleInfo articleInfo) {
        new CommonDialog.Builder((Context)this.getActivity()).setMessage((CharSequence)"\u662f\u5426\u5220\u9664\u52a8\u6001").setLeftButton((CharSequence)"\u5220\u9664", (dialog, which) -> this.mDiscoverArticlePresenter.deleteArticle(ServiceFactory.getAccountService().getHqToken(), articleInfo.id)).setRightButton(R.string.discover_cancel, null).show();
    }

    @Override
    public CompositeSubscription getCompositeSubscription() {
        return this.mCompositeSubscription;
    }

    @Override
    public void onHandlerArticleLikeStateSuccess(boolean isToLike, int handlePosition) {
        if (this.mRecyclerView != null && this.mRecyclerView.getAdapter() != null && this.mRecyclerView.getAdapter() instanceof DiscoverBaseArticleListAdapter) {
            DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter = (DiscoverBaseArticleListAdapter)this.mRecyclerView.getAdapter();
            this.handleDoubleParise(isToLike, handlePosition, discoverBaseArticleListAdapter);
        }
    }

    protected void handleDoubleParise(boolean isToLike, int handlePosition, DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter) {
        if (discoverBaseArticleListAdapter == null) {
            return;
        }
        HomeDiscoverArticleItemBean homeDiscoverArticleItemBean = (HomeDiscoverArticleItemBean)discoverBaseArticleListAdapter.getItem(handlePosition);
        if (homeDiscoverArticleItemBean != null) {
            if (isToLike) {
                if (!homeDiscoverArticleItemBean.isLikeArticle()) {
                    homeDiscoverArticleItemBean.isLike = 1;
                    ++homeDiscoverArticleItemBean.pointsCount;
                    EventBus.getDefault().post((Object)AppMessage.obtain((String)"discover_on_like_article", (Object)homeDiscoverArticleItemBean.id).setObj2((Object)homeDiscoverArticleItemBean.pointsCount));
                }
            } else if (homeDiscoverArticleItemBean.isLikeArticle()) {
                homeDiscoverArticleItemBean.isLike = 0;
                --homeDiscoverArticleItemBean.pointsCount;
                EventBus.getDefault().post((Object)AppMessage.obtain((String)"discover_on_unlike_article", (Object)homeDiscoverArticleItemBean.id).setObj2((Object)homeDiscoverArticleItemBean.pointsCount));
            }
        }
    }

    private void popShareWindow(ArticleInfo articleInfo) {
        if (articleInfo == null) {
            return;
        }
        StatAgent.onEvent((Context)this.getContext(), (String)"Home_CourseDetail_clickCourseShare");
        if (this.mOnDiscoverShareImpl == null) {
            this.mOnDiscoverShareImpl = new OnDiscoverShareImpl((Activity)this.getActivity());
        }
        this.mOnDiscoverShareImpl.popShareWindow(articleInfo, (View)this.mRecyclerView, this.getBelongPage(), new OnDiscoverShareImpl.OnShareStatAndSuccessListener(){

            public void onHandleStat(ShareTypeModel shareTypeModel) {
                BaseDiscoverArticleListFragment.this.mArticleStatPresenter.statArticleShare(((BaseDiscoverArticleListFragment)BaseDiscoverArticleListFragment.this).mShareArticleInfo.id, ServiceFactory.getAccountService().getHqToken());
            }

            public void onShareSuccess(SHARE_MEDIA shareMedia) {
                BaseDiscoverArticleListFragment.this.handleShareSuccess();
            }
        });
    }

    private void handleForwardClick(ArticleInfo articleInfo) {
        this.mShareArticleInfo = articleInfo;
        DiscoverRouterUtils.startForwardDynamic((Context)this.getActivity(), articleInfo);
        StatAgent.onAppShare((Context)this.getContext(), (String)this.getBelongPage(), (String)"\u8f6c\u53d1", (long)articleInfo.id, (String)articleInfo.getShareStatContent(), (String)"\u94fe\u63a5");
    }

    protected void showNoticeView() {
        this.mRefreshNoticeView.setVisibility(0);
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mRefreshNoticeView.getLayoutParams();
        params.topMargin = 0;
        this.mRefreshNoticeView.setLayoutParams((ViewGroup.LayoutParams)params);
        int totalMargin = DisplayUtils.dip2px((float)-33.0f);
        ValueAnimator anim2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, totalMargin});
        anim2.setDuration(300L);
        anim2.setStartDelay(1500L);
        anim2.start();
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (animation.getAnimatedValue() instanceof Float) {
                    float cVal = ((Float)animation.getAnimatedValue()).floatValue();
                    ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)BaseDiscoverArticleListFragment.this.mRefreshNoticeView.getLayoutParams();
                    params.topMargin = (int)cVal;
                    BaseDiscoverArticleListFragment.this.mRefreshNoticeView.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            }
        });
        anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                BaseDiscoverArticleListFragment.this.mRefreshNoticeView.setVisibility(8);
            }

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
            }
        });
    }

    protected void refreshArticleList() {
    }

    public void setPresenter(Object presenter) {
    }

    public boolean isActive() {
        return this.isAdded();
    }

    @Override
    protected String onGetIntentId() {
        return this.mIntentIdString;
    }

    public void onEvent(AppMessage appMessage) {
        if ("discover_comment_article".equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (Long)appMessage.getObj();
                int passRelayCount = -1;
                if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Integer) {
                    passRelayCount = (Integer)appMessage.getObj2();
                }
                this.updateReplyCountByArticleId((DiscoverBaseArticleListAdapter)((Object)this.mAdapter), passRelayCount, articleId);
            }
            return;
        }
        if ("discover_on_like_article".equals(appMessage.getWhat()) || "discover_on_unlike_article".equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (Long)appMessage.getObj();
                Log.e((String)"TAG", (String)"BaseDiscoverArticleListFragment onEvent updatePraiseAndPointCountByArticleId:");
                this.updatePraiseAndPointCountByArticleId((DiscoverBaseArticleListAdapter)((Object)this.mAdapter), appMessage, articleId);
            }
            return;
        }
        if ("discover_comment_article_comment".equals(appMessage.getWhat())) {
            if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Long) {
                long articleId = (Long)appMessage.getObj2();
                int passRelayCount = -1;
                if (appMessage.getObj3() != null && appMessage.getObj3() instanceof Integer) {
                    passRelayCount = (Integer)appMessage.getObj3();
                }
                this.updateReplyCountByArticleId((DiscoverBaseArticleListAdapter)((Object)this.mAdapter), passRelayCount, articleId);
            }
            return;
        }
        if ("discover_on_delete_article".equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (Long)appMessage.getObj();
                boolean isCurrentObject = false;
                if (appMessage.getFromObject() != null && appMessage.getFromObject().equals(this)) {
                    isCurrentObject = true;
                }
                this.updateArticleListByArticleId(articleId, isCurrentObject);
            }
            return;
        }
        if ("discover_on_share_article".equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (Long)appMessage.getObj();
                this.handleItemShareCount((DiscoverBaseArticleListAdapter)((Object)this.mAdapter), appMessage, articleId);
            }
            return;
        }
        if ("discover_on_transmit_article".equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (Long)appMessage.getObj();
                this.handleItemTransmitCount((DiscoverBaseArticleListAdapter)((Object)this.mAdapter), appMessage, articleId);
            }
            return;
        }
    }

    private void handleItemTransmitCount(DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter, AppMessage appMessage, long articleId) {
        try {
            int findIndex = this.findHandlePos(discoverBaseArticleListAdapter, articleId);
            if (findIndex != -1 && discoverBaseArticleListAdapter != null) {
                HomeDiscoverArticleItemBean findItem = (HomeDiscoverArticleItemBean)discoverBaseArticleListAdapter.getDatas().get(findIndex);
                int transmitCount = -1;
                if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Integer) {
                    transmitCount = (Integer)appMessage.getObj2();
                }
                findItem.transmitCount = transmitCount != -1 ? transmitCount : ++findItem.transmitCount;
                Log.e((String)"TAG", (String)"BaseDiscoverArticleListFragment handleItemTransmitCount:");
                findIndex = this.needToDealFindIndex(findIndex);
                if (findIndex != -1) {
                    discoverBaseArticleListAdapter.notifyItemChanged(findIndex + discoverBaseArticleListAdapter.getHeaderCount(), "transmitCount");
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"handleItemShareCount try catch error", (Throwable)e);
        }
    }

    private void handleItemShareCount(DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter, AppMessage appMessage, long articleId) {
        try {
            int findIndex = this.findHandlePos(discoverBaseArticleListAdapter, articleId);
            if (findIndex != -1 && discoverBaseArticleListAdapter != null) {
                HomeDiscoverArticleItemBean findItem = (HomeDiscoverArticleItemBean)discoverBaseArticleListAdapter.getDatas().get(findIndex);
                int shareCount = -1;
                if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Integer) {
                    shareCount = (Integer)appMessage.getObj2();
                }
                findItem.shareCount = shareCount != -1 ? shareCount : ++findItem.shareCount;
                findIndex = this.needToDealFindIndex(findIndex);
                if (findIndex != -1) {
                    discoverBaseArticleListAdapter.notifyItemChanged(findIndex + discoverBaseArticleListAdapter.getHeaderCount(), "shareCount");
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"handleItemShareCount try catch error", (Throwable)e);
        }
    }

    protected void updateReplyCountByArticleId(DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter, int passReplyCount, long articleId) {
        try {
            int findIndex = this.findHandlePos(discoverBaseArticleListAdapter, articleId);
            if (findIndex != -1 && discoverBaseArticleListAdapter != null) {
                HomeDiscoverArticleItemBean findItem = (HomeDiscoverArticleItemBean)discoverBaseArticleListAdapter.getDatas().get(findIndex);
                findItem.replyCount = passReplyCount != -1 ? passReplyCount : ++findItem.replyCount;
                findIndex = this.needToDealFindIndex(findIndex);
                if (findIndex != -1) {
                    discoverBaseArticleListAdapter.notifyItemChanged(findIndex + discoverBaseArticleListAdapter.getHeaderCount(), "replayCount");
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"updateReplyCountByArticleId try catch error", (Throwable)e);
        }
    }

    protected void updatePraiseAndPointCountByArticleId(DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter, AppMessage appMessage, long articleId) {
        try {
            int findIndex = this.findHandlePos(discoverBaseArticleListAdapter, articleId);
            if (findIndex != -1 && discoverBaseArticleListAdapter != null) {
                HomeDiscoverArticleItemBean findItem = (HomeDiscoverArticleItemBean)discoverBaseArticleListAdapter.getDatas().get(findIndex);
                if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Integer) {
                    findItem.pointsCount = (Integer)appMessage.getObj2();
                }
                if ("discover_on_like_article".equals(appMessage.getWhat())) {
                    findItem.isLike = 1;
                } else if ("discover_on_unlike_article".equals(appMessage.getWhat())) {
                    findItem.isLike = 0;
                }
                findIndex = this.needToDealFindIndex(findIndex);
                if (findIndex != -1) {
                    discoverBaseArticleListAdapter.notifyItemChanged(findIndex + discoverBaseArticleListAdapter.getHeaderCount(), "praise");
                }
            }
        }
        catch (Exception e) {
            YLog.error((Object)TAG, (String)"updatePraiseAndPointCountByArticleId try catch error", (Throwable)e);
        }
    }

    protected int needToDealFindIndex(int findIndex) {
        return findIndex;
    }

    private int findHandlePos(DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter, long articleId) {
        int findIndex = -1;
        if (discoverBaseArticleListAdapter != null && discoverBaseArticleListAdapter.getDatas() != null && discoverBaseArticleListAdapter.getDatas().size() > 0) {
            for (int i = 0; i < discoverBaseArticleListAdapter.getDatas().size(); ++i) {
                HomeDiscoverArticleItemBean homeDiscoverArticleItemBean = (HomeDiscoverArticleItemBean)discoverBaseArticleListAdapter.getDatas().get(i);
                if (homeDiscoverArticleItemBean.id != articleId) continue;
                findIndex = i;
                break;
            }
        }
        return findIndex;
    }

    @Override
    public void onDeleteArticleSuccess(long articleId) {
        EventBus.getDefault().post((Object)AppMessage.obtain((String)"discover_on_delete_article", (Object)articleId).setFromObject((Object)this));
    }

    protected void updateArticleListByArticleId(long articleId, boolean isCurrentObject) {
        if (isCurrentObject) {
            ToastUtil.showMessageWithSuccess((Context)this.getActivity(), (CharSequence)"\u64cd\u4f5c\u6210\u529f");
        }
        if (this.mAdapter != null && this.mAdapter.getDatas() != null && this.mAdapter.getDatas().size() > 0) {
            List datas = this.mAdapter.getDatas();
            ArrayList<Integer> deletedIndexList = new ArrayList<Integer>();
            for (int i = 0; i < datas.size(); ++i) {
                HomeDiscoverArticleItemBean discoverArticleItemBean = (HomeDiscoverArticleItemBean)datas.get(i);
                if (discoverArticleItemBean.id != articleId) continue;
                deletedIndexList.add(i);
            }
            if (deletedIndexList.size() > 0) {
                for (int j = deletedIndexList.size() - 1; j >= 0; --j) {
                    datas.remove((Integer)deletedIndexList.get(j));
                }
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    @Override
    public void onDeleteArticleFailure(Throwable e, long articleId) {
        YLog.error((Object)this, (String)"onDeleteArticleFailure: ", (Throwable)e);
        if (e instanceof HqException) {
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)e.getMessage());
        } else {
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    public void notifyAdapterDataSetChanged() {
        if (this.mAdapter != null && this.mAdapter.getDatas() != null && this.mAdapter.getDatas().size() > 0) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public abstract int getChildFragmentType();

    public abstract String getBelongPage();

    protected String getBelongSeat() {
        return this.mStatParams != null ? this.mStatParams.getBelongSeat() : "";
    }

    protected void addScrollAutoPlayVideo() {
        if (this.mRecyclerView != null) {
            this.mScrollCalculatorHelper = new ScrollCalculatorHelper((Context)this.getActivity());
            this.mItemExposureReportHelper = new ItemExposureReportHelper(this.mRecyclerView);
            this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                    BaseDiscoverArticleListFragment.this.mScrollCalculatorHelper.onScrollStateChanged(recyclerView, newState);
                    BaseDiscoverArticleListFragment.this.mItemExposureReportHelper.onScrollStateChanged(recyclerView, newState);
                }

                public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                    BaseDiscoverArticleListFragment.this.mScrollCalculatorHelper.onScrolled(recyclerView, dx, dy);
                }
            });
        }
    }

    public void onPause() {
        super.onPause();
        this.pauseVideo();
        this.uploadArticleExposureStat();
        this.handleAppStayStat();
        this.mIsInteractiveState = false;
    }

    protected void uploadArticleExposureStat() {
        SparseIntArray exposureDate = this.mItemExposureReportHelper.getData();
        if (exposureDate.size() > 0) {
            ArrayList<Long> articleIdList = new ArrayList<Long>();
            for (int i = 0; i < exposureDate.size(); ++i) {
                ArticleInfo articleInfo;
                int position = exposureDate.keyAt(i);
                int count = exposureDate.valueAt(i);
                int realPosition = ((DiscoverBaseArticleListAdapter)((Object)this.mAdapter)).getArticleRealPosition(position);
                if (realPosition < 0 || (articleInfo = (ArticleInfo)this.mAdapter.getItem(realPosition)) == null) continue;
                long articleId = articleInfo.id;
                for (int j = 0; j < count; ++j) {
                    articleIdList.add(articleId);
                }
            }
            this.mItemExposureReportHelper.reset();
            this.mArticleStatPresenter.statArticleExposure(articleIdList.toArray(new Long[articleIdList.size()]), ServiceFactory.getAccountService().getHqToken(), 2);
        }
    }

    public void onResume() {
        super.onResume();
        this.resetEnterTime();
        this.mIsInteractiveState = true;
    }

    public void onStop() {
        super.onStop();
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (!isVisibleToUser) {
            this.pauseVideo();
            this.handleAppStayStat();
            this.mIsInteractiveState = false;
        } else {
            this.resetEnterTime();
            this.mIsInteractiveState = true;
        }
    }

    public void pauseVideo() {
        if (this.mScrollCalculatorHelper != null) {
            this.mScrollCalculatorHelper.pauseVideo();
        }
    }

    public void setEnableLoadMoreAndRefresh(boolean enable) {
        if (this.mSmartRefreshLayout != null) {
            this.mSmartRefreshLayout.setEnableLoadMore(enable);
            this.mSmartRefreshLayout.setEnableRefresh(enable);
        }
    }

    protected void finishFirstLoading() {
        this.finishFirstLoading(false);
    }

    protected void finishFirstLoading(boolean isNoMore) {
        this.hideSkeletonView();
        this.mSmartRefreshLayout.handleFinishRefreshData(isNoMore);
    }

    protected void showErrorView(Throwable throwable) {
        this.hideSkeletonView();
        this.mSmartRefreshLayout.handleErrorData(false);
        this.mRefreshNoticeView.setVisibility(8);
        this.mLoadingDataStatusView.setLoadingBackgroundColor(Color.parseColor((String)"#ffffff"));
        this.mLoadingDataStatusView.showErrorViewByThrowable(throwable);
    }

    protected void showDataView() {
        this.mSmartRefreshLayout.setVisibility(0);
        this.mLoadingDataStatusView.setVisibility(8);
    }

    protected void showEmptyView() {
        this.hideSkeletonView();
        this.mSmartRefreshLayout.handleNoData();
        this.mRefreshNoticeView.setVisibility(8);
    }

    protected void showSkeletonView() {
        try {
            if (this.mSkeletonScreen == null) {
                this.mSkeletonScreen = Skeleton.bind((RecyclerView)this.mRecyclerView).adapter(this.mAdapter).shimmer(true).color(R.color.discover_common_shimmer_color).angle(20).frozen(false).duration(1600).count(8).load(R.layout.discover_item_skeleton_discovers).show();
            } else {
                this.mSkeletonScreen.show();
            }
            this.setEnableLoadMoreAndRefresh(false);
        }
        catch (Exception e) {
            YLog.error((Object)this, (String)" BaseDiscoverArticleListFragment showSkeletonView ", (Throwable)e);
        }
    }

    protected void hideSkeletonView() {
        try {
            if (this.mSkeletonScreen != null) {
                this.mSkeletonScreen.hide();
                this.mSkeletonScreen.hide();
            }
        }
        catch (Exception e) {
            YLog.error((Object)this, (String)" BaseDiscoverArticleListFragment hideSkeletonView ", (Throwable)e);
        }
        this.setEnableLoadMoreAndRefresh(true);
    }

    protected boolean isEnableSkeletonLoading() {
        return true;
    }

    private void handleShareSuccess() {
        if (this.mShareCreditMvpPresenter == null) {
            this.mShareCreditMvpPresenter = new NotifyShareCreditPresenter();
            this.mShareCreditMvpPresenter.onAttach((MvpView)this);
        }
        this.mShareCreditMvpPresenter.notifyShareCredit(ServiceFactory.getAccountService().getHqToken(), ShareCrediteRes.TYPE_SHARE, ShareCrediteRes.CONTENT_TYPE_DISCOVER, ShareCrediteRes.TASK_SAHRE, this.mShareArticleInfo != null ? this.mShareArticleInfo.id : 0L);
    }

    public void onNotifyShareCreditSuccess(int credit, long contentId) {
        ToastUtil.showCreiditMessage((Context)this.getActivity(), (CharSequence)"\u5206\u4eab\u6210\u529f", (int)credit);
        EventBus.getDefault().post((Object)AppMessage.obtain((String)"discover_on_share_article", (Object)contentId).setObj2((Object)(this.mShareArticleInfo != null ? this.mShareArticleInfo.shareCount + 1 : -1)));
    }

    public void onNotifyShareCreditFailed(Throwable throwable, long contentId) {
        ToastUtil.showCreiditMessage((Context)this.getActivity(), (CharSequence)"\u5206\u4eab\u6210\u529f");
        EventBus.getDefault().post((Object)AppMessage.obtain((String)"discover_on_share_article", (Object)contentId).setObj2((Object)(this.mShareArticleInfo != null ? this.mShareArticleInfo.shareCount + 1 : -1)));
    }

    public void addPublishArticleInfoToFirst(HomeDiscoverArticleItemBean homeDiscoverArticleItemBean) {
        if (homeDiscoverArticleItemBean == null) {
            return;
        }
        if (this.mAdapter != null) {
            if (this.mLocalMakeArticleItemBeans == null) {
                this.mLocalMakeArticleItemBeans = new ArrayList<HomeDiscoverArticleItemBean>();
            }
            if (this.mSmartRefreshLayout != null && this.mLoadingDataStatusView != null && this.mLoadingDataStatusView.getVisibility() == 0) {
                this.showDataView();
            }
            this.mAdapter.addData(0, (Object)homeDiscoverArticleItemBean);
            this.mLocalMakeArticleItemBeans.add(homeDiscoverArticleItemBean);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    protected void filterAndDeleteLocalArticleItemBeans() {
        if (this.mLocalMakeArticleItemBeans != null && this.mLocalMakeArticleItemBeans.size() > 0 && this.mAdapter != null && this.mAdapter.getDatas() != null && this.mAdapter.getDatas().size() > 0) {
            List datas = this.mAdapter.getDatas();
            Iterator iterator = datas.iterator();
            block0: while (iterator.hasNext()) {
                HomeDiscoverArticleItemBean articleItemBean = (HomeDiscoverArticleItemBean)iterator.next();
                for (HomeDiscoverArticleItemBean localMakeArticleItemBean : this.mLocalMakeArticleItemBeans) {
                    if (localMakeArticleItemBean == null || articleItemBean == null || articleItemBean.id != localMakeArticleItemBean.id) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            this.mLocalMakeArticleItemBeans.clear();
        }
    }

    protected boolean getOpenAppStayStat() {
        return false;
    }

    protected void resetEnterTime() {
        if (this.getOpenAppStayStat()) {
            this.enterTime = SystemClock.elapsedRealtime();
        }
    }

    protected void handleAppStayStat() {
        if (this.getOpenAppStayStat()) {
            long eventDuration = SystemClock.elapsedRealtime() - this.enterTime;
            long time = eventDuration / 1000L;
            DiscoverStat.onAppStay((Context)this.getActivity(), this.getBelongPage(), this.getBelongSeat(), time, null, null, null);
        }
    }

    protected void initAutoLoadMore() {
        if (this.mRecyclerView == null || this.mSmartRefreshLayout == null) {
            return;
        }
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                boolean smartCanLoadMore = BaseDiscoverArticleListFragment.this.mSmartRefreshLayout.getmSmartRefreshLayout().canLoadMore();
                if (!BaseDiscoverArticleListFragment.this.canLoadMore || !smartCanLoadMore) {
                    return;
                }
                LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                int itemCount = layoutManager.getItemCount();
                int lastPosition = layoutManager.findLastVisibleItemPosition();
                if (lastPosition >= itemCount - 10 && BaseDiscoverArticleListFragment.this.mSmartRefreshLayout.getmSmartRefreshLayout().getState() == RefreshState.None) {
                    BaseDiscoverArticleListFragment.this.getNextPageDataList();
                }
            }
        });
    }

    protected void getNextPageDataList() {
    }

    protected boolean isShowOfficialAccountDialog() {
        return false;
    }

    protected void showFollowSuccessDialog(long authorId) {
        if (!this.mIsInteractiveState) {
            return;
        }
        WechatSaleBean wechatSaleBean = new WechatSaleBean();
        wechatSaleBean.setFromPage(3);
        OfficialAccountDialogBean officialAccountDialogBean = new OfficialAccountDialogBean();
        officialAccountDialogBean.setId(authorId);
        officialAccountDialogBean.setType(4);
        officialAccountDialogBean.setSuccessTips("\u5df2\u5173\u6ce8");
        officialAccountDialogBean.setObjId(authorId);
        StatParamStorage.StatParams statParams = StatParamStorage.getInstance().getStatParams(1);
        AppRouter.startOfficialAccountDiversionActivity((Context)this.getActivity(), (String)wechatSaleBean.getJsonString(), (String)statParams.getBelongPage(), (String)officialAccountDialogBean.getJsonString());
    }

    @Override
    public void onGetPublishedArticleDetailSuccess(@NonNull HomeDiscoverArticleItemBean articleInfo) {
        if (this.mSmartRefreshLayout != null) {
            this.mSmartRefreshLayout.finishRefresh();
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.scrollToPosition(0);
        }
        if (this.mAdapter != null) {
            this.mAdapter.addData(0, (Object)articleInfo);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onGetPublishedArticleDetailFailure(@NonNull Throwable throwable) {
        if (this.mSmartRefreshLayout != null) {
            this.mSmartRefreshLayout.finishRefresh();
        }
    }

    public void getPublishArticleDetail(@Nullable String passport, long authorId, long articleId, HomeDiscoverArticleItemBean homeDiscoverArticleItemBean) {
        if (this.mSmartRefreshLayout != null) {
            this.mSmartRefreshLayout.getmSmartRefreshLayout().autoRefreshAnimationOnly();
        }
        if (this.mPublishedPresenter == null) {
            this.mPublishedPresenter = new PublishedImpl<PublishedContract.View>(DataApiFactory.getInstance().getDiscoverjApi());
            this.mPublishedPresenter.onAttach(this);
        }
        this.mPublishedPresenter.getPublishArticleDetail(passport, authorId, articleId, homeDiscoverArticleItemBean);
    }
}

