/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.edu24.data.server.discover.entity.ArticleImage;
import com.edu24ol.newclass.discover.widget.DefaultImageViewTarget;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.glide.tranform.SafeRoundedCorners;
import com.hqwx.android.service.AppRouter;
import com.yy.android.educommon.log.YLog;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DiscoverShortPicListAdapter
extends RecyclerView.Adapter<DiscoverShortPicViewHolder> {
    private Context mContext;
    private List<ArticleImage> mPicList = new ArrayList<ArticleImage>();
    public static final int DISCOVER_IMG_WIDTH = 5;
    private final SafeRoundedCorners mRoundedCorners;
    private CenterCrop mCenterCrop;
    private OnGetSizeListener mOnGetSizeListener = null;

    public void setDatas(List<ArticleImage> picList) {
        this.mPicList.clear();
        if (picList != null) {
            this.mPicList.addAll(picList);
        }
    }

    public DiscoverShortPicListAdapter(Context context) {
        this.mContext = context;
        this.mRoundedCorners = new SafeRoundedCorners(DisplayUtils.dip2px((Context)this.mContext, (float)2.0f));
        this.mCenterCrop = new CenterCrop();
    }

    @NonNull
    public DiscoverShortPicViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        RecyclerView.LayoutParams layoutParams = new RecyclerView.LayoutParams(-2, -2);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return new DiscoverShortPicViewHolder((View)linearLayout);
    }

    public void onBindViewHolder(final @NonNull DiscoverShortPicViewHolder discoverShortPicViewHolder, final int position) {
        if (this.getItemCount() == 1) {
            int oWidth = 0;
            int oHeight = 0;
            ArticleImage articleImage = this.mPicList.get(position);
            int width = articleImage.getWidth();
            int height = articleImage.getHeight();
            if (width > 0 && height > 0) {
                boolean shouldBeWider;
                int maxWidth;
                float displayAspectRatio = (float)width / (float)height;
                int maxHeight = maxWidth = DisplayUtils.getScreenWidth((Context)this.mContext) - this.mContext.getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;
                float maxAspectRatio = (float)maxWidth / (float)maxHeight;
                boolean bl = shouldBeWider = displayAspectRatio > maxAspectRatio;
                if (shouldBeWider) {
                    width = Math.min(width, maxWidth);
                    height = (int)((float)width / displayAspectRatio);
                } else {
                    height = Math.min(height, maxHeight);
                    width = (int)((float)height * displayAspectRatio);
                }
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)discoverShortPicViewHolder.itemView.getLayoutParams();
                layoutParams.width = width;
                layoutParams.height = height;
                discoverShortPicViewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (this.mOnGetSizeListener != null) {
                    this.mOnGetSizeListener.onGetSize(layoutParams.width, layoutParams.height);
                }
                ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(articleImage.getUrl()).diskCacheStrategy(DiskCacheStrategy.ALL)).transform((Transformation)this.mRoundedCorners)).override(oWidth, oHeight)).into((Target)new DefaultImageViewTarget(discoverShortPicViewHolder.mImageView));
            } else {
                YLog.warn((Object)((Object)this), (String)"onBindViewHolder: Image width or height invalid.");
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(articleImage.getUrl()).diskCacheStrategy(DiskCacheStrategy.ALL)).transform((Transformation)this.mRoundedCorners)).listener((RequestListener)new RequestListener<Drawable>(){

                    public boolean onLoadFailed(@androidx.annotation.Nullable @Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)discoverShortPicViewHolder.itemView.getLayoutParams();
                        layoutParams.height = layoutParams.width = DisplayUtils.dip2px((Context)DiscoverShortPicListAdapter.this.mContext, (float)100.0f);
                        if (DiscoverShortPicListAdapter.this.mOnGetSizeListener != null) {
                            DiscoverShortPicListAdapter.this.mOnGetSizeListener.onGetSize(layoutParams.width, layoutParams.height);
                        }
                        return false;
                    }

                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)discoverShortPicViewHolder.itemView.getLayoutParams();
                        layoutParams.width = resource.getIntrinsicWidth();
                        layoutParams.height = resource.getIntrinsicHeight();
                        if (DiscoverShortPicListAdapter.this.mOnGetSizeListener != null) {
                            DiscoverShortPicListAdapter.this.mOnGetSizeListener.onGetSize(layoutParams.width, layoutParams.height);
                        }
                        return false;
                    }
                }).into((Target)new DefaultImageViewTarget(discoverShortPicViewHolder.mImageView));
            }
        } else {
            int mImageWidth = (DisplayUtils.getScreenWidth((Context)this.mContext) - this.mContext.getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2 - DisplayUtils.dip2px((Context)this.mContext, (float)5.0f) * 2) / 3;
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)discoverShortPicViewHolder.itemView.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = mImageWidth;
            discoverShortPicViewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(this.mPicList.get(position).getUrl()).diskCacheStrategy(DiskCacheStrategy.ALL)).transform(new Transformation[]{this.mCenterCrop, this.mRoundedCorners})).override(mImageWidth, mImageWidth)).into((Target)new DefaultImageViewTarget(discoverShortPicViewHolder.mImageView));
        }
        discoverShortPicViewHolder.mImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ArrayList<String> pictureList = new ArrayList<String>(DiscoverShortPicListAdapter.this.mPicList.size());
                for (ArticleImage articleImage : DiscoverShortPicListAdapter.this.mPicList) {
                    pictureList.add(articleImage.getUrl());
                }
                AppRouter.startImageViewer((Context)DiscoverShortPicListAdapter.this.mContext, pictureList, (int)position);
            }
        });
    }

    public int getItemCount() {
        return this.mPicList == null ? 0 : this.mPicList.size();
    }

    public void setOnGetSizeListener(OnGetSizeListener onGetSizeListener) {
        this.mOnGetSizeListener = onGetSizeListener;
    }

    public static interface OnGetSizeListener {
        public void onGetSize(int var1, int var2);
    }

    class DiscoverShortPicViewHolder
    extends RecyclerView.ViewHolder {
        ImageView mImageView;

        public DiscoverShortPicViewHolder(View itemView) {
            super(itemView);
            this.mImageView = new ImageView(DiscoverShortPicListAdapter.this.mContext);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
            LinearLayout linearLayout = (LinearLayout)itemView;
            linearLayout.addView((View)this.mImageView);
        }
    }
}

