/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.discover.entity.HomeDiscoverArticleItemBean;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleEvent;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderComment;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderFAQ;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderLong;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderShort;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderVideo;
import com.edu24ol.newclass.discover.viewholder.DiscoverBaseArticleListItemViewHolder;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderComment;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderDelete;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderFAQ;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderLong;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderShort;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderVideo;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.adapter.BaseViewHolderNew;
import com.hqwx.android.platform.widgets.AbstractBaseRecycleViewAdapter;
import java.util.List;

public class DiscoverBaseArticleListAdapter
extends AbstractBaseRecycleViewAdapter<HomeDiscoverArticleItemBean> {
    public static final int RECOMMEND_LAST_READ_TYPE = -1;
    public static final int RECOMMEND_HEADER_VIEW = -2;
    public static final int ITEM_TYPE_FOLLOW_TOPIC = -3;
    public static final int ITEM_TYPE_RECOMMEND_TOPIC = -4;
    public static final int ITEM_TYPE_FOLLOW_EMPTY = -5;
    public static final int ITEM_TYPE_FOLLOW_EMPTY_HEADER = -6;
    public static final int ITEM_TYPE_FOLLOW_EMPTY_AUTHOR = -7;
    public static final int SHORT_DISCOVER_ART_TYPE = 0;
    public static final int LONG_DISCOVER_ART_TYPE = 1;
    public static final int VIDEO_DISCOVER_ART_TYPE = 2;
    public static final int FAQ_DISCOVER_ART_TYPE = 3;
    public static final int COMMENT_DISCOVER_ART_TYPE = 4;
    public static final int FORWARD_SHORT_ART_TYPE = 11;
    public static final int FORWARD_LONG_ART_TYPE = 12;
    public static final int FORWARD_VIDEO_ART_TYPE = 13;
    public static final int FORWARD_FAQ_ART_TYPE = 14;
    public static final int FORWARD_COMMENT_ART_TYPE = 15;
    public static final int FORWARD_DELETE_ART_TYPE = 19;
    protected boolean mIsHaveLastRead = false;
    protected int mRefreshDataCount = 0;
    protected List<HomeDiscoverArticleItemBean> mStickRecommendList;
    private boolean isShowTag = true;
    protected DiscoverArticleEvent.HeaderEventListener mHeaderEventListener;
    protected DiscoverArticleEvent.MoreMenuEventListener mMoreMenuEventListener;
    protected DiscoverArticleEvent.CommonEventListener mCommonEventListener;
    protected DiscoverArticleEvent.FooterEventListener mFooterEventListener;

    public boolean isHaveLastRead() {
        return this.mIsHaveLastRead;
    }

    public void setHaveLastRead(boolean haveLastRead) {
        this.mIsHaveLastRead = haveLastRead;
    }

    public int getRefreshDataCount() {
        return this.mRefreshDataCount;
    }

    public void setRefreshDataCount(int refreshDataCount) {
        this.mRefreshDataCount = refreshDataCount;
    }

    public void setStickRecommendList(List<HomeDiscoverArticleItemBean> homeDiscoverArticleItemBeans) {
        this.mStickRecommendList = homeDiscoverArticleItemBeans;
    }

    public boolean hasStickArticleList() {
        return this.mStickRecommendList != null && this.mStickRecommendList.size() > 0;
    }

    public List<HomeDiscoverArticleItemBean> getStickRecommendList() {
        return this.mStickRecommendList;
    }

    public boolean isShowTag() {
        return this.isShowTag;
    }

    public void setShowTag(boolean showTag) {
        this.isShowTag = showTag;
    }

    public boolean isShowAttention() {
        return false;
    }

    public boolean isShowMoreButton() {
        return true;
    }

    public void setHeaderEventListener(DiscoverArticleEvent.HeaderEventListener headerEventListener) {
        this.mHeaderEventListener = headerEventListener;
    }

    public void setMoreMenuEventListener(DiscoverArticleEvent.MoreMenuEventListener moreMenuEventListener) {
        this.mMoreMenuEventListener = moreMenuEventListener;
    }

    public void setCommonEventListener(DiscoverArticleEvent.CommonEventListener commonEventListener) {
        this.mCommonEventListener = commonEventListener;
    }

    public void setFooterEventListener(DiscoverArticleEvent.FooterEventListener footerEventListener) {
        this.mFooterEventListener = footerEventListener;
    }

    public DiscoverBaseArticleListAdapter(Context context) {
        super(context);
    }

    protected View initItemLayoutInflater(ViewGroup parent, int resource) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(resource, parent, false);
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        DiscoverBaseArticleListItemViewHolder holder = null;
        if (viewType == 0) {
            holder = new DiscoverArticleItemViewHolderShort(this.mContext, this.initItemLayoutInflater(viewGroup, R.layout.discover_item_article_layout_short));
        } else if (viewType == 1) {
            holder = new DiscoverArticleItemViewHolderLong(this.mContext, this.initItemLayoutInflater(viewGroup, R.layout.discover_item_article_layout_long));
        } else if (viewType == 2) {
            holder = new DiscoverArticleItemViewHolderVideo(this.mContext, LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.discover_item_article_layout_video, viewGroup, false));
        } else if (viewType == 3) {
            holder = new DiscoverArticleItemViewHolderFAQ(this.mContext, this.initItemLayoutInflater(viewGroup, R.layout.discover_item_article_layout_faq));
        } else if (viewType == 4) {
            holder = new DiscoverArticleItemViewHolderComment(this.mContext, this.initItemLayoutInflater(viewGroup, R.layout.discover_item_article_layout_comment));
        } else if (viewType == 11) {
            holder = new DiscoverForwardArticleItemViewHolderShort(this.mContext, LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.discover_item_forward_article_short, viewGroup, false));
        } else if (viewType == 12) {
            holder = new DiscoverForwardArticleItemViewHolderLong(this.mContext, LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.discover_item_forward_article_long, viewGroup, false));
        } else if (viewType == 13) {
            holder = new DiscoverForwardArticleItemViewHolderVideo(this.mContext, LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.discover_item_forward_article_video, viewGroup, false));
        } else if (viewType == 15) {
            holder = new DiscoverForwardArticleItemViewHolderComment(this.mContext, LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.discover_item_forward_article_comment, viewGroup, false));
        } else if (viewType == 14) {
            holder = new DiscoverForwardArticleItemViewHolderFAQ(this.mContext, LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.discover_item_forward_article_faq, viewGroup, false));
        } else if (viewType == 19) {
            holder = new DiscoverForwardArticleItemViewHolderDelete(this.mContext, LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.discover_item_forward_delete_layout, viewGroup, false));
        }
        if (holder != null) {
            holder.setShowTag(this.isShowTag());
            holder.setShowAttention(this.isShowAttention());
            holder.setShowMoreButton(this.isShowMoreButton());
            holder.setHeaderEventListener(this.mHeaderEventListener);
            holder.setFooterEventListener(this.mFooterEventListener);
            holder.setCommonEventListener(this.mCommonEventListener);
            holder.setMoreMenuEventListener(this.mMoreMenuEventListener);
        }
        return holder;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (payloads.isEmpty()) {
            this.onBindViewHolder(holder, position);
        } else {
            HomeDiscoverArticleItemBean bean = (HomeDiscoverArticleItemBean)this.getItem(position);
            if (bean == null) {
                return;
            }
            if (holder instanceof BaseViewHolderNew) {
                ((BaseViewHolderNew)holder).onBindViewHolder(this.mContext, (Object)bean, payloads, position);
            }
        }
    }

    public int getArticleRealPosition(int position) {
        return position;
    }

    public int getHeaderCount() {
        return 0;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        HomeDiscoverArticleItemBean bean = (HomeDiscoverArticleItemBean)this.getItem(position);
        if (bean == null) {
            return;
        }
        if (viewHolder instanceof BaseViewHolderNew) {
            ((BaseViewHolderNew)viewHolder).onBindViewHolder(this.mContext, (Object)bean, position);
        }
    }

    public int getItemViewType(int position) {
        super.getItemViewType(position);
        HomeDiscoverArticleItemBean articleInfo = (HomeDiscoverArticleItemBean)this.getItem(position);
        if (articleInfo == null) {
            return 0;
        }
        if (articleInfo.getRootId() > 0L) {
            ArticleInfo forwardArticleInfo = articleInfo.getRootParentArticle();
            if (forwardArticleInfo == null) {
                return 19;
            }
            if (forwardArticleInfo.isShortArticle() || forwardArticleInfo.isMessageArticle()) {
                return 11;
            }
            if (forwardArticleInfo.isLongArticle()) {
                return 12;
            }
            if (forwardArticleInfo.isVideoArticle()) {
                return 13;
            }
            if (forwardArticleInfo.isFAQArticle()) {
                return 14;
            }
            if (forwardArticleInfo.isCommentArticle()) {
                return 15;
            }
        } else {
            if (articleInfo.isShortArticle() || articleInfo.isMessageArticle()) {
                return 0;
            }
            if (articleInfo.isLongArticle()) {
                return 1;
            }
            if (articleInfo.isVideoArticle()) {
                return 2;
            }
            if (articleInfo.isFAQArticle()) {
                return 3;
            }
            if (articleInfo.isCommentArticle()) {
                return 4;
            }
        }
        return 0;
    }
}

