/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.discover;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.HomeDiscoverArticleItemBean;
import com.edu24ol.newclass.discover.adapter.DiscoverBaseArticleListAdapter;
import com.edu24ol.newclass.discover.base.BaseDiscoverArticleListFragment;
import com.edu24ol.newclass.discover.home.IRefreshable;
import com.edu24ol.newclass.discover.home.recommend.HomeDiscoverRecommendListAdapter;
import com.edu24ol.newclass.discover.presenter.IAuthorFollowActionPresenter;
import com.edu24ol.newclass.discover.presenter.ui.IDiscoverAuthorFollowUI;
import com.edu24ol.newclass.discover.stat.DiscoverStat;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.AppMessage;
import com.hqwx.android.platform.exception.HqException;
import com.hqwx.android.platform.stat.StatAgent;
import com.hqwx.android.platform.utils.DoubleClickCheckUtils;
import com.hqwx.android.platform.utils.ToastUtil;
import com.hqwx.android.platform.widgets.LoadingDataStatusView;
import com.hqwx.android.platform.widgets.pullrefresh.HqwxRefreshLayout;
import com.hqwx.android.platform.widgets.pullrefresh.listener.OnRefreshLoadMoreListener;
import com.hqwx.android.service.AppRouter;
import com.hqwx.android.service.ServiceFactory;
import com.yy.android.educommon.log.YLog;
import com.yy.android.educommon.utils.NetworkUtil;
import de.greenrobot.event.EventBus;
import java.util.List;

public abstract class AbsDiscoverFollowAuthorFragment<P extends IAuthorFollowActionPresenter>
extends BaseDiscoverArticleListFragment
implements IDiscoverAuthorFollowUI,
IRefreshable {
    protected P mPresenter;
    protected boolean mIsFirstLoading = true;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.discover_common_frg_child_recommend_layout, null);
        this.getFragmentArguments(this.getArguments());
        this.mChildFragmentType = this.getChildFragmentType();
        this.initView(view);
        this.initListener();
        this.initAdapter();
        this.mPresenter = this.createPresenter();
        EventBus.getDefault().register((Object)this);
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.loadFirstPageData();
    }

    private void loadFirstPageData() {
        if (this.isEnableSkeletonLoading()) {
            this.showSkeletonView();
            this.loadData();
        } else {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        if (this.mSmartRefreshLayout != null) {
            this.mSmartRefreshLayout.getmSmartRefreshLayout().autoRefresh();
        }
    }

    protected void getFragmentArguments(Bundle bundle) {
    }

    protected abstract P createPresenter();

    protected DiscoverBaseArticleListAdapter getAdapter() {
        return new HomeDiscoverRecommendListAdapter((Context)this.getActivity());
    }

    private void initView(View view) {
        this.mRefreshNoticeView = (TextView)view.findViewById(R.id.discover_recommend_notice_view);
        this.mSmartRefreshLayout = (HqwxRefreshLayout)view.findViewById(R.id.smart_refresh_layout);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.recycler_view);
        this.addScrollAutoPlayVideo();
        this.mLoadingDataStatusView = (LoadingDataStatusView)view.findViewById(R.id.recommend_loading_status_view);
    }

    private void initListener() {
        this.mLoadingDataStatusView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbsDiscoverFollowAuthorFragment.this.loadFirstPageData();
            }
        });
        this.setOnRefreshLoadMoreListener();
    }

    protected void setOnRefreshLoadMoreListener() {
        this.mSmartRefreshLayout.setOnRefreshLoadMoreListener(new OnRefreshLoadMoreListener(){

            public void onLoadMore(HqwxRefreshLayout refreshLayout) {
                if (AbsDiscoverFollowAuthorFragment.this.mChildFragmentType == 1) {
                    StatAgent.onEvent((Context)AbsDiscoverFollowAuthorFragment.this.getContext(), (String)"Discovery_RecommendedList_slideLoading");
                }
                AbsDiscoverFollowAuthorFragment.this.getNextArticleItemList();
                StatAgent.onAppDiscoverRefresh((Context)AbsDiscoverFollowAuthorFragment.this.getActivity(), (String)AbsDiscoverFollowAuthorFragment.this.getBelongSeat(), (String)"\u9ed8\u8ba4", (String)"\u4e0a\u6ed1\u52a0\u8f7d");
            }

            public void onRefresh(HqwxRefreshLayout refreshLayout) {
                AbsDiscoverFollowAuthorFragment.this.loadData();
            }
        });
    }

    private void loadData() {
        if (this.mIsFirstLoading) {
            this.mIsFirstLoading = false;
            this.getFirstArticleItemListAndShowDataView();
        } else {
            if (this.mChildFragmentType == 1) {
                StatAgent.onEvent((Context)this.getContext(), (String)"Discovery_RecommendedList_dropdownLoading");
            }
            this.getRefreshArticleItemList();
        }
        StatAgent.onAppDiscoverRefresh((Context)this.getActivity(), (String)this.getBelongSeat(), (String)"\u9ed8\u8ba4", (String)"\u4e0b\u62c9\u5237\u65b0");
    }

    @Override
    protected void refreshArticleList() {
        this.getFirstArticleItemListAndShowDataView();
    }

    private void getFirstArticleItemListAndShowDataView() {
        this.showDataView();
        this.getFirstArticleItemList();
    }

    protected abstract void getFirstArticleItemList();

    protected abstract void getNextArticleItemList();

    protected abstract void getRefreshArticleItemList();

    @Override
    public void onDestroyView() {
        EventBus.getDefault().unregister((Object)this);
        super.onDestroyView();
    }

    @Override
    public void onRefreshNoData() {
        this.mSmartRefreshLayout.finishRefresh();
    }

    @Override
    public void onNoData() {
        this.showEmptyView();
    }

    @Override
    public void onNoMoreData(boolean isRefresh) {
        if (isRefresh) {
            this.mSmartRefreshLayout.handleFinishRefreshData(true);
        } else {
            this.mSmartRefreshLayout.handleFinishLoadMoreData(true);
        }
    }

    protected void setGetFirstListFail(Throwable throwable) {
        this.mIsFirstLoading = true;
        this.showErrorView(throwable);
    }

    protected void setGetMoreListSuccess(List<HomeDiscoverArticleItemBean> articleItemBeanList) {
        if (this.mAdapter != null) {
            if (articleItemBeanList != null) {
                this.mAdapter.addData(articleItemBeanList);
                this.mAdapter.notifyDataSetChanged();
            }
            this.mSmartRefreshLayout.handleFinishLoadMoreData(false);
        }
    }

    @Override
    public void onAttentionClick(CheckBox checkBox, ArticleAuthor author, boolean attention) {
        super.onAttentionClick(checkBox, author, attention);
        if (!DoubleClickCheckUtils.vertifyDurationByTime((int)500)) {
            checkBox.setChecked(!checkBox.isChecked());
            return;
        }
        if (!NetworkUtil.isNetworkAvailable((Context)this.getActivity())) {
            checkBox.setChecked(!checkBox.isChecked());
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)"\u5f53\u524d\u7f51\u7edc\u4e0d\u53ef\u7528");
            return;
        }
        if (!ServiceFactory.getAccountService().isLogin()) {
            AppRouter.startAccountPhoneLogin((Context)this.getContext());
            checkBox.setChecked(!attention);
            return;
        }
        if (attention) {
            if (this.mChildFragmentType == 5) {
                DiscoverStat.onAppFollow("\u53d1\u73b0\u5e7f\u573a\u9875", "\u8d26\u53f7", author.id, author.name);
            } else if (this.mChildFragmentType == 1) {
                DiscoverStat.onAppFollow("\u53d1\u73b0\u63a8\u8350\u9875", "\u8d26\u53f7", author.id, author.name);
            }
            this.mPresenter.followAuthor(ServiceFactory.getAccountService().getHqToken(), author.id);
        } else {
            this.mPresenter.unFollowAuthor(ServiceFactory.getAccountService().getHqToken(), author.id);
        }
    }

    private void updateAttention(long authorId, boolean attention) {
        if (this.mAdapter == null || this.mAdapter.getDatas() == null) {
            return;
        }
        List beans = this.mAdapter.getDatas();
        if (attention) {
            for (HomeDiscoverArticleItemBean bean : beans) {
                if (bean.authorId != authorId) continue;
                bean.author.setIsAttend(true);
            }
            YLog.info((Object)this, (String)("onAttentionClick: follow " + authorId));
        } else {
            for (HomeDiscoverArticleItemBean bean : beans) {
                if (bean.authorId != authorId) continue;
                bean.author.setIsAttend(false);
            }
            YLog.info((Object)this, (String)("onAttentionClick: unFollow " + authorId));
        }
        LinearLayoutManager layoutManager = (LinearLayoutManager)this.mRecyclerView.getLayoutManager();
        int startPosition = layoutManager.findFirstVisibleItemPosition();
        int endPosition = layoutManager.findLastVisibleItemPosition();
        try {
            this.mAdapter.notifyItemRangeChanged(startPosition, endPosition - startPosition + 5, "attention");
        }
        catch (Exception e) {
            Log.e((String)"TAG", (String)"DiscoverRecommendFragment updateAttention Exception:", (Throwable)e);
            this.mAdapter.notifyItemRangeChanged(startPosition, endPosition - startPosition + 1, "attention");
        }
    }

    @Override
    public void onFollowAuthorSuccess(long authorId) {
        EventBus.getDefault().post((Object)AppMessage.obtain((String)"discover_on_follow_author", (Object)authorId));
        YLog.info((Object)this, (String)"onFollowSuccess: ");
    }

    @Override
    public void onFollowAuthorFail(Throwable throwable) {
        if (throwable instanceof HqException) {
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)throwable.getMessage());
        } else {
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)"\u5173\u6ce8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        YLog.error((Object)this, (String)"onFollowFailure: ", (Throwable)throwable);
    }

    @Override
    public void onUnFollowAuthorSuccess(long authorId) {
        EventBus.getDefault().post((Object)AppMessage.obtain((String)"discover_on_unfollow_author", (Object)authorId));
        YLog.info((Object)this, (String)"onUnFollowSuccess: ");
    }

    @Override
    public void onUnFollowAuthorFail(Throwable throwable) {
        if (throwable instanceof HqException) {
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)throwable.getMessage());
        } else {
            ToastUtil.showMessage((Context)this.getActivity(), (CharSequence)"\u53d6\u6d88\u5173\u6ce8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        YLog.error((Object)this, (String)"onUnFollowFailure: ", (Throwable)throwable);
    }

    protected void setShowNoticeView(String showText) {
        this.mRefreshNoticeView.setText((CharSequence)showText);
        super.showNoticeView();
    }

    @Override
    public void onEvent(AppMessage appMessage) {
        super.onEvent(appMessage);
        if ("discover_on_follow_author".equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long authorId = (Long)appMessage.getObj();
                this.updateAttention(authorId, true);
                if (this.isShowOfficialAccountDialog()) {
                    this.showFollowSuccessDialog(authorId);
                } else {
                    if (!this.mIsInteractiveState) {
                        return;
                    }
                    ToastUtil.showMessageWithSuccess((Context)this.getActivity(), (CharSequence)"\u5173\u6ce8\u6210\u529f");
                }
            }
        } else if ("discover_on_unfollow_author".equals(appMessage.getWhat()) && appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
            long authorId = (Long)appMessage.getObj();
            this.updateAttention(authorId, false);
        }
    }

    @Override
    public void showLoadingDialog() {
    }

    @Override
    public void dismissLoadingDialog() {
    }
}

