/*
 * Decompiled with CFR 0.152.
 */
package com.edu24ol.newclass.base;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.fragment.app.FragmentTransaction;
import com.edu24ol.newclass.base.FragmentPage;
import java.util.List;

public class CommonViewPagerAdapter
extends FragmentPagerAdapter {
    private List<FragmentPage> mFragmentPages;
    private FragmentManager mFragmentManager;
    private long baseId = 0L;
    private FragmentTransaction mCurTransaction;

    public CommonViewPagerAdapter(FragmentManager fragmentManager, List<FragmentPage> fragmentPages) {
        super(fragmentManager);
        this.mFragmentManager = fragmentManager;
        this.mFragmentPages = fragmentPages;
    }

    public void setFragmentPages(List<FragmentPage> fragmentPages) {
        this.mFragmentPages = fragmentPages;
        this.notifyDataSetChanged();
    }

    public Fragment getItem(int position) {
        if (this.mFragmentPages != null && this.mFragmentPages.size() > 0) {
            return this.mFragmentPages.get(position).getFragment();
        }
        return null;
    }

    public CharSequence getPageTitle(int position) {
        FragmentPage fragmentPage;
        if (this.mFragmentPages != null && this.mFragmentPages.size() > 0 && (fragmentPage = this.mFragmentPages.get(position)) != null) {
            return fragmentPage.getTitle();
        }
        return "";
    }

    public int getCount() {
        return this.mFragmentPages != null ? this.mFragmentPages.size() : 0;
    }

    public long getItemId(int position) {
        return this.baseId + (long)position;
    }

    public void changeId(int n) {
        this.baseId += (long)(this.getCount() + n);
    }

    public void clear() {
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        for (int i = 0; this.mFragmentPages != null && i < this.mFragmentPages.size(); ++i) {
            Fragment fragment = this.mFragmentPages.get((int)i).mFragment;
            if (fragment == null) continue;
            this.mCurTransaction.remove(fragment);
        }
        this.mCurTransaction.commitNowAllowingStateLoss();
    }
}

