package com.edu24ol.newclass.widget.viewpager.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;

import com.hqwx.android.platform.utils.DisplayUtils;

/**
 * createBy keepon
 */
public class HomeLinePageIndicator extends EffectLinePageIndicator {

    private int mDp1;
    private float[] mRadii;
    private Path mPath;
    private RectF mRectF;

    public HomeLinePageIndicator(Context context) {
        super(context);
    }

    public HomeLinePageIndicator(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    protected void initView(Context context, AttributeSet attrs, int defStyle) {
        super.initView(context, attrs, defStyle);
        mDp1 = DisplayUtils.dip2px(1);
        int radius = DisplayUtils.dip2px(1.5f);
        mRadii = new float[]{radius, radius, radius, radius, radius, radius,
                radius, radius};
        mPath = new Path();
        mRectF = new RectF();
    }

    protected void drawLines(Canvas canvas, int count, float lineWidthAndGap, float verticalOffset,
                             float horizontalOffset) {
        for (int i = 0; i < count; i++) {
            float dx1 = horizontalOffset + (i * lineWidthAndGap);
            float dx2;
            if (i == 1) {
                dx2 = dx1 + mSecondLineWidth;
            } else {
                dx2 = dx1 + mLineWidth;
            }
            mPath.reset();
            mRectF.set(dx1, verticalOffset - mDp1, dx2, verticalOffset + mDp1);
            mPath.addRoundRect(mRectF, mRadii, Path.Direction.CCW);
            canvas.drawPath(mPath, (i == mCurrentPage) ? mPaintSelected : mPaintUnselected);
        }
    }
}
