package com.edu24ol.newclass.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.FrameLayout;

import com.hqwx.android.photopicker.R;


/**
 * Created by Deemo on 16/11/9".
 * *_*
 */
public class RatioFrameLayout extends FrameLayout {

    private float mWHRatio;

    public RatioFrameLayout(Context context) {
        super(context);
        init(context, null);
    }

    public RatioFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public RatioFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.PhotoPickerRatioFrameLayout);
        mWHRatio = ta.getFloat(R.styleable.PhotoPickerRatioFrameLayout_ratio, 1.0f);
        ta.recycle();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = MeasureSpec.getSize(widthMeasureSpec);
        int height = Math.round(width * mWHRatio);
        int heightMs = MeasureSpec.makeMeasureSpec(height, MeasureSpec.EXACTLY);
        super.onMeasure(widthMeasureSpec, heightMs);
    }
}
