package com.edu24ol.newclass.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;

/**
 * Created by zhanghong on 2017/12/3.
 * <p>
 * 我的评论列表当中的星星数
 */

public class EvaluateStarsCountView extends LinearLayout {

    private LinearLayout mRootLinearLayout;

    private Context mContext;

    public EvaluateStarsCountView(Context context) {
        this(context, null);
    }

    public EvaluateStarsCountView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from(context)
                .inflate(R.layout.discover_common_widget_evaluate_starts_count_view, this, true);
        mContext = context;
        mRootLinearLayout = (LinearLayout) findViewById(R.id.evaluate_count_root_view);
    }

    public void setStarsCount(int count) {
        setStarsCountWithDrawable(R.mipmap.discover_common_ic_star, count);
    }

    public void setStarsCountWithDrawable(int drawable, int count) {
        mRootLinearLayout.removeAllViews();
        for (int i = 0; i < count; i++) {
            ImageView starImg = new ImageView(mContext);
            starImg.setImageResource(drawable);
            LayoutParams layoutParams =
                    new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                            ViewGroup.LayoutParams.WRAP_CONTENT);
            layoutParams.setMargins(0, 0, DisplayUtils.dip2px(mContext, 5), 0);
            starImg.setLayoutParams(layoutParams);
            mRootLinearLayout.addView(starImg);
        }
    }

}
