package com.edu24ol.newclass.video;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.widgets.AbstractBaseRecycleViewAdapter;

import base.BasePlayListItem;

/**
 * 视频播放列表展示
 */

public class VideosPlayListAdapter<T extends BasePlayListItem>
        extends AbstractBaseRecycleViewAdapter<T> {

    public int mCurrentPlayPosition;

    public void updatePlayPosition(int currentPlayPosition) {
        mCurrentPlayPosition = currentPlayPosition;
    }

    public interface OnItemClickListener {
        void onItemClick(int position);
    }

    public OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public VideosPlayListAdapter(Context context) {
        super(context);
    }

    private View initItemLayoutInflater(ViewGroup parent, int resourse) {
        return LayoutInflater.from(parent.getContext()).inflate(resourse, parent, false);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new VideosPlayItemViewHolder(
                initItemLayoutInflater(viewGroup, R.layout.pc_item_horizontal_videos_list));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, final int position) {
        if (viewHolder instanceof VideosPlayItemViewHolder) {
            VideosPlayItemViewHolder itemViewHolder = (VideosPlayItemViewHolder) viewHolder;

            BasePlayListItem playListItem = getItem(position);
            if (!TextUtils.isEmpty(playListItem.getDownloadedFilePath())) {
                itemViewHolder.mAlreadyDownloadVideoImg.setVisibility(View.VISIBLE);
            } else {
                itemViewHolder.mAlreadyDownloadVideoImg.setVisibility(View.GONE);
            }
            itemViewHolder.mVideoTitleView.setText(playListItem.getName());
            if (mCurrentPlayPosition == position) {
                itemViewHolder.mVideoTitleView.setTextColor(mContext.getResources().getColor(R.color.new_tab_selected_text_color));
            } else {
                itemViewHolder.mVideoTitleView.setTextColor(Color.parseColor("#ffffff"));
            }
            itemViewHolder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemClick(position);
                    }
                }
            });
        }
    }

    private static class VideosPlayItemViewHolder extends RecyclerView.ViewHolder {

        private ImageView mAlreadyDownloadVideoImg;
        private TextView mVideoTitleView;

        public VideosPlayItemViewHolder(View itemView) {
            super(itemView);
            mAlreadyDownloadVideoImg =
                    itemView.findViewById(R.id.item_horizontal_videos_list_already_down_icon);
            mVideoTitleView = itemView.findViewById(R.id.item_horizontal_videos_list_name);
        }
    }
}
