package com.edu24ol.newclass.video;

import static com.edu24.data.models.CourseRecordDetailBean.DEF_HIGH;
import static com.edu24.data.models.CourseRecordDetailBean.DEF_STANDARD;
import static com.edu24.data.models.CourseRecordDetailBean.DEF_ULTRA;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.CountDownTimer;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.stat.StatAgent;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.ToastUtil;
import com.hqwx.android.playercontroller.CommonVideoController;
import com.hqwx.android.playercontroller.CourseVideoDefinitionView;
import com.hqwx.android.playercontroller.CourseVideoPlaySpeedView;
import com.hqwx.android.playercontroller.util.PrefUtils;
import com.hqwx.android.service.ServiceFactory;
import com.yy.android.educommon.utils.NetworkUtil;

import java.util.ArrayList;

import base.BasePlayListItem;
import base.IBaseVideoView;
import base.IVideoPlayer;
import base.PlayListController;
import base.VideoDefinition;
import io.vov.vitamio.caidao.TimeKeeper;
import io.vov.vitamio.utils.StringUtils;

/**
 * 普通视频播放控制
 */

public class VideoMediaController extends CommonVideoController implements View.OnClickListener {

    private static final String TAG = "MediaController";
    private Context mContext;
    private IBaseVideoView mCommonVideoView;
    private LinearLayout mTopLayout;
    private RelativeLayout mBottomLayout;
    private RelativeLayout mLockedBottomLayout;
    private RelativeLayout mContentLayout;
    private RelativeLayout mLockedRightLayout;
    private RelativeLayout mRightLayout;

    private View mBottomHorizontalView;
    private View mBottomVerticalView;
    private View mBottomLockedView;
    private SeekBar mHorizontalSeekBar;
    private SeekBar mOrientalSeekBar;
    private View mFullScreenView;

    private View mTopCastView;
    private View mTopBackView;
    private TextView mTopTitleView;
    private TextView mHorizontalCurrentTimeView;
    private TextView mHorizontalTotalTimeView;
    private TextView mVerticalCurrentTimeView;
    private TextView mVerticalTotalTimeView;
    private ImageView mVerticalReplayView;
    private ImageView mHorizontalReplayView;

    private TextView mCurrentPlaySpeedView;
    private View mSpeedControlRootView;
    private TextView mCurrentPlayDefinitionView;
    private View mPlayDefinitionRootView;

    private View mVideosListRootView;
    private View mVideosListShowView;
    private VideosPlayListAdapter mVideoPlayListAdapter;

    private ImageView mHorizontalStatusImg;
    private ImageView mVerticalStatusImg;
    private ImageView mHorizontalNextLessonImg;
    private View mContentPlayCompletionRootView;
    private View mContentLoadVideoErrorView;
    private View mContentMobileNetNoticeRootView;
    private CourseVideoDefinitionView mCourseVideoDefinitionView;

    private ImageView mQrCodeIv;
    private CheckBox mLockVideoCbx; //锁屏按钮
    private SeekBar mLockedSeekBar; //锁屏状态下的seekbar
    private Button mSeeMoreBtn;
    /**
     * 画中画
     */
    private View mPortraitPipView, mHorizontalPipView;

    private long mStartPlayTime; //本节视频开始播放时间

    private View mContentCompletionHomeworkView;

    private int mSecondCategory;    //考试id

    private PlayListController<BasePlayListItem> mPlayListController;

    public void setPlayList(ArrayList<BasePlayListItem> playList) {
        mPlayListController.setPlayList(playList);
        if (mVideoPlayListAdapter != null) {
            mVideoPlayListAdapter.setData(playList);
            mVideoPlayListAdapter.notifyDataSetChanged();
        }
    }

    public IVideoPlayer getVideoPlayer() {
        if (mCommonVideoView != null) {
            return mCommonVideoView.getMediaPlayer();
        }
        return null;
    }

    public void setStartPosition(long startPosition) {
        if (mCommonVideoView != null) {
            mCommonVideoView.setPosition(startPosition);
        }
    }

    public long getCurrentPosition() {
        if (mCommonVideoView != null) {
            return mCommonVideoView.getCurrentPosition();
        }
        return 0;
    }

    public long getDuration() {
        if (mCommonVideoView != null) {
            return mCommonVideoView.getDuration();
        }
        return 0;
    }

    public long getStartPlayTime() {
        return mStartPlayTime;
    }

    public void setPlayVideoPath(boolean isShowTipsLoading) {
        BasePlayListItem playListItem = mPlayListController.getCurrentPlayItem();
        if (playListItem != null) {
            //设置播放器的播放地址 及初始化相关参数
            String videoUrl =
                    playListItem.getPlayVideoUrl(PrefUtils.getVideoDefinition(mContext));
            if (mContentLayout != null) {
                setContentViewVisible(false);
                if (NetworkUtil.isMobileNetwork(getContext()) &&
                        getVideoMode(videoUrl) != TimeKeeper.MODE_NATIVE_VIDEO &&
                        !ServiceFactory.getAppService().isAllowMobileNetPlayVideo(mContext)) {
                    showLoadingMobileNetNotice();
                    return;
                }
            }
            setReplayViewVisible(false);
            hideSeeMoreButton();
            mTopTitleView.setText(playListItem.getName());
            mStartPlayTime = System.currentTimeMillis();
            setCurrentStartPosition();
            resetMediaController();

            mCommonVideoView.setVideoPath(videoUrl);
            int videoDefinition = playListItem.getVideoDefinitionByUrl(videoUrl);
            if (videoDefinition > 0) {
                showDefinitionView();
                setCurrentPlayDefinitionViewText(videoDefinition);
            } else {
                hideDefinitionView();
            }
            initMediaPlaySpeed();
//        setTipsLoading();
            if (isShowTipsLoading) {
                showFirstLoading();
            }
        }
    }

    public boolean isPlaying() {
        return (mCommonVideoView != null && mCommonVideoView.isPlaying());
    }

    public VideoMediaController(Context context) {
        this(context, null);
    }

    public VideoMediaController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        mContext = context;
        mPlayListController = new PlayListController<>();
        mTopLayout = findViewById(R.id.common_controller_top_layout);
        mBottomLayout = findViewById(R.id.common_controller_bottom_layout);
        mLockedBottomLayout = findViewById(R.id.common_controller_locked_bottom_layout);
        mContentLayout = findViewById(R.id.common_controller_content_layout);
        mLockedRightLayout = findViewById(R.id.common_controller_locked_right_layout);
        addLockView();
        mRightLayout = findViewById(R.id.common_controller_right_layout);
        mQrCodeIv = findViewById(R.id.common_iv_qrcode);
        mCommonVideoView = super.getCommonVideoView();
        mSeeMoreBtn = findViewById(R.id.btn_see_more);
        mSeeMoreBtn.setOnClickListener(this);
        initView();
        initMediaPlaySpeed();
        initPlayDefinition();
        initAnimation();
    }

    private void initView() {
        LayoutInflater.from(mContext).inflate(R.layout.pc_course_video_top_layout, mTopLayout,
                true);

        LayoutInflater.from(mContext)
            .inflate(R.layout.discover_common_video_bottom_horizontal_layout, mBottomLayout, true);
        LayoutInflater.from(mContext)
            .inflate(R.layout.pc_course_video_bottom_vertial_layout, mBottomLayout, true);
        LayoutInflater.from(mContext)
            .inflate(R.layout.pc_locked_seekbar_layout, mLockedBottomLayout, true);
        mBottomLockedView = mLockedBottomLayout.getChildAt(0);
        mLockedSeekBar = mLockedBottomLayout.findViewById(R.id.lock_sbar_controller);
        mLockedSeekBar.setPadding(0, 0, 0, 0);
        mLockedSeekBar.setOnSeekBarChangeListener(mSeekBarChangeListener);

        if (mBottomLayout.getChildCount() == 2) {
            mBottomHorizontalView = mBottomLayout.getChildAt(0);
            mBottomVerticalView = mBottomLayout.getChildAt(1);
        }
        mTopCastView = findViewById(R.id.icon_portrait_controller_cast);
        mTopBackView = findViewById(R.id.icon_video_controller_back_img);
        mTopTitleView = findViewById(R.id.icon_video_controller_title_view);
        mFullScreenView = findViewById(R.id.btn_toggle_screen);
        mHorizontalSeekBar = findViewById(R.id.sbar_controller);
        mHorizontalSeekBar.setPadding(0, 0, 0, 0);
        mHorizontalSeekBar.setOnSeekBarChangeListener(mSeekBarChangeListener);

        mOrientalSeekBar = findViewById(R.id.sbar_portrait_controller);
        mOrientalSeekBar.setPadding(0, 0, 0, 0);
        mOrientalSeekBar.setOnSeekBarChangeListener(mSeekBarChangeListener);

        mHorizontalCurrentTimeView = findViewById(R.id.tv_horizontal_controller_current_time);
        mHorizontalTotalTimeView = findViewById(R.id.tv_horizontal_controller_total_time);
        mVerticalCurrentTimeView = findViewById(R.id.tv_portrait_controller_current_time);
        mVerticalTotalTimeView = findViewById(R.id.tv_portrait_controller_total_time);
        mCurrentPlaySpeedView = findViewById(R.id.tv_horizontal_controller_speed);
        mCurrentPlayDefinitionView = findViewById(R.id.tv_horizontal_controller_definition);
        mVideosListShowView = findViewById(R.id.chk_horizontal_controller_videos);
        mHorizontalStatusImg = findViewById(R.id.chk_horizontal_controller_start);
        mVerticalStatusImg = findViewById(R.id.icon_portrait_pause_btn);
        mHorizontalNextLessonImg = findViewById(R.id.chk_horizontal_controller_next_lesson);
        mVerticalReplayView = findViewById(R.id.portrait_controller_replay_view);
        mHorizontalReplayView = findViewById(R.id.horizontal_controller_replay_view);
        mLockedSeekBar = mBottomLockedView.findViewById(R.id.lock_sbar_controller);

        mHorizontalPipView = findViewById(com.hqwx.android.playercontroller.R.id.icon_horizontal_top_play_window);
        mPortraitPipView = findViewById(com.hqwx.android.playercontroller.R.id.iv_portrait_pip);

        setMediaControllerOrientation(false);
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            mSeekBar = mHorizontalSeekBar;
        } else {
            mSeekBar = mOrientalSeekBar;
        }

        mFullScreenView.setOnClickListener(this);
        mCurrentPlaySpeedView.setOnClickListener(this);
        mCurrentPlayDefinitionView.setOnClickListener(this);
        mVideosListShowView.setOnClickListener(this);
        mHorizontalStatusImg.setOnClickListener(this);
        mVerticalStatusImg.setOnClickListener(this);
        mHorizontalNextLessonImg.setOnClickListener(this);
        mTopBackView.setOnClickListener(this);
        mVerticalReplayView.setOnClickListener(this);
        mHorizontalReplayView.setOnClickListener(this);
        mTopLayout.setVisibility(View.GONE);
        mBottomLayout.setVisibility(View.GONE);
        mTopCastView.setOnClickListener(this);
    }

    public void setLockedRightLayoutVisible(boolean isVisible) {
        if (isVisible) {
            mLockedRightLayout.setVisibility(View.VISIBLE);
        } else {
            mLockedRightLayout.setVisibility(View.INVISIBLE);
        }
    }

    private void setBottomLayoutByLockState(boolean isLocked) {
        if (isLocked) {
            mIsLocked = true;
            mSeekBar = mLockedSeekBar;
            hideWithOutAnimation();
            mBottomLockedView.setVisibility(View.VISIBLE);
        } else {
            mIsLocked = false;
            mSeekBar = mHorizontalSeekBar;
            mBottomLockedView.setVisibility(View.INVISIBLE);
            showWithAnimation();
        }
    }

    private void addLockView() {
        mLockVideoCbx = new CheckBox(mContext);
        mLockVideoCbx.setChecked(false);
        mLockVideoCbx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (mOnEventListener != null) {
                    mOnEventListener.onSetLockEnable(isChecked);
                }
                setBottomLayoutByLockState(isChecked);
            }
        });
        mLockVideoCbx.setButtonDrawable(new ColorDrawable(Color.TRANSPARENT));
        mLockVideoCbx.setBackground(
                mContext.getResources().getDrawable(R.drawable.video_lock_state_selector));

        mLockedRightLayout.addView(mLockVideoCbx);
        LayoutParams layoutParams = (LayoutParams) mLockVideoCbx.getLayoutParams();
        layoutParams.addRule(RelativeLayout.CENTER_VERTICAL);
        layoutParams.rightMargin = DisplayUtils.dip2px(mContext, 25);
        mLockVideoCbx.setLayoutParams(layoutParams);
    }

    private void setVideoLockState(boolean isLock) {
        if (mLockVideoCbx != null) {
            mLockVideoCbx.setChecked(isLock);
        }
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.btn_toggle_screen) {
            if (getResources().getConfiguration().orientation ==
                    Configuration.ORIENTATION_LANDSCAPE) {
                setVideoLockState(false);
            } else {
                if (mLockVideoCbx == null) {
                    addLockView();
                }
            }
            if (mOnEventListener != null) {
                mOnEventListener.onFullScreenClick();
            }
        } else if (id == R.id.tv_horizontal_controller_speed) {
            setLockedRightLayoutVisible(false);
            setRightViewVisible(false);
            setRightViewVisible(true);
            if (mSpeedControlRootView == null) {
                CourseVideoPlaySpeedView courseVideoPlaySpeedView =
                        new CourseVideoPlaySpeedView(mContext);
                mRightLayout.addView(courseVideoPlaySpeedView,
                        new LayoutParams(LayoutParams.WRAP_CONTENT,
                                DisplayUtils.getScreenHeight(getContext())));
                courseVideoPlaySpeedView.setOnCourseVideoSpeedItemClickListener(
                        new CourseVideoPlaySpeedView.OnCourseVideoSpeedItemClickListener() {
                            @Override
                            public void onCourseVideoSpeedClick(float rate, String rateText) {
                                switch (rateText) {
                                    case "0.8X":
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_SpeedPlayback_click0.8x");
                                        break;
                                    case "1.0X":
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_SpeedPlayback_click1.0x");
                                        break;
                                    case "1.2X":
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_SpeedPlayback_click1.2x");
                                        break;
                                    case "1.3X":
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_SpeedPlayback_click1.3x");
                                        break;
                                    case "1.5X":
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_SpeedPlayback_click1.5x");
                                        break;
                                    case "2.0X":
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_SpeedPlayback_click2.0x");
                                        break;
                                    default:
                                        break;
                                }
                                mCommonVideoView.setRate(rate);
                                mCurrentPlaySpeedView.setText(rateText);
                                setRightViewVisible(false);
                            }
                        });
                courseVideoPlaySpeedView
                        .setCurrentSelectedView(PrefUtils.getMediaPlaySpeed(mContext));
                mSpeedControlRootView =
                        mRightLayout.findViewById(R.id.course_horizontal_video_speed_root_view);
            }
            mSpeedControlRootView.setVisibility(View.VISIBLE);
        } else if (id == R.id.tv_horizontal_controller_definition) {
            setLockedRightLayoutVisible(false);
            setRightViewVisible(false);
            setRightViewVisible(true);
            if (mPlayDefinitionRootView == null) {
                mCourseVideoDefinitionView = new CourseVideoDefinitionView(mContext);
                mRightLayout.addView(mCourseVideoDefinitionView,
                        new LayoutParams(LayoutParams.WRAP_CONTENT,
                                DisplayUtils.getScreenHeight(getContext())));
                mCourseVideoDefinitionView.setOnCourseVideoDefinitionClickListener(
                        new CourseVideoDefinitionView.OnCourseVideoDefinitionClickListener() {
                            @Override
                            public void onCourseVideoDefinitionClick(int clickDefinitionType) {
                                //保存播放进度后，继续播放
                                setCurrentPlayDefinitionViewText(clickDefinitionType);
                                PrefUtils.setVideoDefinition(mContext,clickDefinitionType);
                                switch (clickDefinitionType) {
                                    case DEF_ULTRA: {
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_VideoResolution_clickUltra");
//                                    mCurrentCourseRecordDetailBean.mVideoUrl = mCurrentCourseRecordDetailBean.mHighUrl;
                                    }
                                    break;
                                    case DEF_HIGH: {
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_VideoResolution_clickHD");
//                                    mCurrentCourseRecordDetailBean.mVideoUrl = mCurrentCourseRecordDetailBean.mMiddleUrl;
                                    }
                                    break;
                                    case DEF_STANDARD: {
                                        StatAgent.onEvent(getContext(),
                                                "FullScreen_VideoResolution_clickSD");
//                                    mCurrentCourseRecordDetailBean.mVideoUrl = mCurrentCourseRecordDetailBean.mStandUrl;
                                    }
                                    break;
                                    default:
                                        break;
                                }
                                saveCurrentVideoPlayProgress();
                                setPlayVideoPath(false);
                                setRightViewVisible(false);

                            }
                        });
                mPlayDefinitionRootView =
                        mRightLayout.findViewById(R.id.course_horizontal_definition_root_view);
            }
            if (mCourseVideoDefinitionView != null) {
                mCourseVideoDefinitionView.setAllVideoDefinition(
                        mPlayListController.getCurrentPlayItem()
                                .getVideoUrlByDefinition(VideoDefinition.ULTRA),
                        mPlayListController.getCurrentPlayItem()
                                .getVideoUrlByDefinition(VideoDefinition.HD),
                        mPlayListController.getCurrentPlayItem()
                                .getVideoUrlByDefinition(VideoDefinition.STANDARTD),
                        PrefUtils.getVideoDefinition(mContext));
            }
            mPlayDefinitionRootView.setVisibility(View.VISIBLE);
        } else if (id == R.id.chk_horizontal_controller_videos) {
            setLockedRightLayoutVisible(false);
            setRightViewVisible(false);
            setRightViewVisible(true);
            if (mVideosListRootView == null) {
                LayoutInflater.from(mContext)
                        .inflate(R.layout.pc_course_horizontal_videos_list_layout,
                                mRightLayout,
                                true);
                mVideosListRootView =
                        mRightLayout.findViewById(R.id.course_horizontal_videos_list_root_view);
                //初始化videosList
                RecyclerView recyclerView =
                        mRightLayout.findViewById(R.id.course_horizontal_videos_recycler_view);
                LinearLayoutManager linearLayoutManager = new LinearLayoutManager(mContext);
                linearLayoutManager.setAutoMeasureEnabled(true);
                recyclerView.setLayoutManager(linearLayoutManager);
                mVideoPlayListAdapter = new VideosPlayListAdapter(mContext);
                mVideoPlayListAdapter.setData(mPlayListController.getPlayList());

                recyclerView.setAdapter(mVideoPlayListAdapter);
                mVideoPlayListAdapter.setOnItemClickListener(
                        new VideosPlayListAdapter.OnItemClickListener() {
                            @Override
                            public void onItemClick(int position) {
                                if (position != mPlayListController.getCurrentPlayPosition()) {
                                    if (mOnEventListener != null) {
                                        mOnEventListener.onVideosItemListClick(position);
                                    }
                                    setPlayVideoByPos(position);
                                }
                            }
                        });
                if (getCurrentPlayListItem() != null) {
                    mVideoPlayListAdapter
                            .updatePlayPosition(mPlayListController.getCurrentPlayPosition());
                }
            } else {
                if (mVideoPlayListAdapter != null && getCurrentPlayListItem() != null) {
                    mVideoPlayListAdapter
                            .updatePlayPosition(mPlayListController.getCurrentPlayPosition());
                    mVideoPlayListAdapter.notifyDataSetChanged();
                }
            }
            mVideosListRootView.setVisibility(View.VISIBLE);
        } else if (id == R.id.chk_horizontal_controller_start || id == R.id.icon_portrait_pause_btn) {
            performDoubleClickWithHide();
        } else if (id == R.id.chk_horizontal_controller_next_lesson) {
            playNextLesson();
        } else if (id == R.id.icon_video_controller_back_img) {
            Log.e("TAG", "  onClick ");
            if (mOnEventListener != null) {
                mOnEventListener.onBackClick();
            }
        } else if (id == R.id.portrait_controller_replay_view || id == R.id.horizontal_controller_replay_view) {
            setPlayVideoPath(true);
        } else if (id == R.id.btn_see_more) {
            if (mSeeMoreClickListener != null) {
                mSeeMoreClickListener.onClick(v);
            }
        } else if (id == R.id.icon_portrait_controller_cast) {
            if (mOnCastViewClickListener != null) {
                mOnCastViewClickListener.onCastViewClicked(v);
            }
        }
    }

    private void initMediaPlaySpeed() {
        int playSpeed = PrefUtils.getMediaPlaySpeed(mContext);
        String playSpeedText = CourseVideoPlaySpeedView.rateSelectText[1];
        float currentRate = CourseVideoPlaySpeedView.rateSelect[1];
        switch (playSpeed) {
            case 0: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[0];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[0];
            }
            break;
            case 1: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[1];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[1];
            }
            break;
            case 2: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[2];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[2];
            }
            break;
            case 3: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[3];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[3];
            }
            break;
            case 4: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[4];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[4];
            }
            break;
            case 5: {
                currentRate = CourseVideoPlaySpeedView.rateSelect[5];
                playSpeedText = CourseVideoPlaySpeedView.rateSelectText[5];
            }
            break;
            default:
                break;
        }
        mCommonVideoView.setRate(currentRate);
        mCurrentPlaySpeedView.setText(playSpeedText);
    }

    private void initPlayDefinition() {
        setCurrentPlayDefinitionViewText(PrefUtils.getVideoDefinition(mContext));
    }

    private void setCurrentPlayDefinitionViewText(int definitionType) {
        switch (definitionType) {
            case DEF_ULTRA: {
                mCurrentPlayDefinitionView.setText("超清");
            }
            break;
            case DEF_HIGH: {
                mCurrentPlayDefinitionView.setText("高清");
            }
            break;
            case DEF_STANDARD: {
                mCurrentPlayDefinitionView.setText("标清");
            }
            break;
            default:
                break;
        }
    }

    public void setPlayVideoByPos(int position) {
        mPlayListController.setCurrentPlayPosition(position);
        saveCurrentVideoPlayProgress();
        setPlayVideoPath(true);
        setRightViewVisible(false);
    }

    private void playNextLesson() {
        BasePlayListItem playListItem = mPlayListController.getNextPlayItem();
        if (playListItem != null) {
            if (!playListItem.isValidVideo()) {
                ToastUtil.showMessage(getContext(), "下一讲视频资源异常！");
                return;
            }
            if (mOnEventListener != null) {
                mOnEventListener
                        .onNextPlayLessonClick(mPlayListController.getCurrentPlayPosition());
            }
            saveCurrentVideoPlayProgress();
            setPlayVideoPath(true);
        } else {
            ToastUtil.showMessage(getContext(), "当前已是最后一讲！");
        }
    }

    private void setCurrentStartPosition() {
//        BasePlayListItem playListItem = mPlayListController.getCurrentPlayItem();
//        if (playListItem != null) {
//            DBCSProVideoPlayRecord dbcsProVideoPlayRecord = DataApiFactory.getInstance().getDBApi().getDBCSProVideoPlayRecord(UserHelper.getUserId(), playListItem.getLessonId(), playListItem.getKnowledgeId());
//            if (dbcsProVideoPlayRecord != null && dbcsProVideoPlayRecord.getLastPlayPosition() != null) {
//                setStartPosition((int) dbcsProVideoPlayRecord.getLastPlayPosition().longValue());
//            } else {
//                setStartPosition(0);
//            }
//        }
    }

    public void saveCurrentVideoPlayProgress() {

//        long position = getCurrentPosition();
//        long duration = getDuration();
//        if (duration - position < 5000) {
//            position = 0;
//        }
//        BasePlayListItem playListItem = mPlayListController.getCurrentPlayItem();
//        playListItem.setStartPlayPosition(position);
//
//        DBCSProVideoPlayRecord dbcsProVideoPlayRecord = new DBCSProVideoPlayRecord();
//        dbcsProVideoPlayRecord.setUserId(UserHelper.getUserId());
//        dbcsProVideoPlayRecord.setLessonId(playListItem.getLessonId());
//        dbcsProVideoPlayRecord.setKnowledgeId(playListItem.getKnowledgeId());
//        dbcsProVideoPlayRecord.setLastPlayPosition(playListItem.getStartPlayPosition());
//        DataApiFactory.getInstance().getDBApi().saveCSProPlayRecord(dbcsProVideoPlayRecord);
    }

    private void setReplayViewVisible(boolean isShowReplay) {
        if (isShowReplay) {
            mHorizontalReplayView.setVisibility(View.VISIBLE);
            mHorizontalStatusImg.setVisibility(View.INVISIBLE);
            mVerticalReplayView.setVisibility(View.VISIBLE);
            mVerticalStatusImg.setVisibility(View.GONE);
        } else {
            mHorizontalStatusImg.setVisibility(View.VISIBLE);
            mHorizontalReplayView.setVisibility(View.INVISIBLE);
            mVerticalStatusImg.setVisibility(View.VISIBLE);
            mVerticalReplayView.setVisibility(View.GONE);
        }
    }

    public void onVideoPlayComplete() {
        setReplayViewVisible(true);
        setVideoLockState(false);
        showWithOutAnimation();
    }

    protected void setVideoContinuePlayWithDrag() {
        setReplayViewVisible(false);
        hide();
    }

    @Override
    protected void showCurrentProgressText(long currentProgress) {
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            mHorizontalCurrentTimeView.setText(StringUtils.generateTime(currentProgress));
        } else {
            mVerticalCurrentTimeView.setText(StringUtils.generateTime(currentProgress));
        }
    }

    @Override
    protected void showTotalProgressText(long totalDuration) {
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            mHorizontalTotalTimeView.setText(StringUtils.generateTime(totalDuration));
        } else {
            mVerticalTotalTimeView.setText(StringUtils.generateTime(totalDuration));
        }
    }

    public void setMediaControllerOrientation(boolean landscape) {
        if (landscape) {
            if (isVideoLocked()) {
                mSeekBar = mLockedSeekBar;
                mBottomLockedView.setVisibility(View.VISIBLE);
            } else {
                mSeekBar = mHorizontalSeekBar;
                mBottomHorizontalView.setVisibility(View.VISIBLE);
            }
            mBottomVerticalView.setVisibility(View.GONE);
            setLockedRightLayoutVisible(true);
        } else {
            mSeekBar = mOrientalSeekBar;
            mBottomVerticalView.setVisibility(View.VISIBLE);
            mBottomHorizontalView.setVisibility(View.GONE);
            mBottomLockedView.setVisibility(View.GONE);
            setRightViewVisible(false);
            setVideoLockState(false);
            setLockedRightLayoutVisible(false);
        }
        updateSeekBarProgress();
    }

    //如果是本地视频则直接播放
    private int getVideoMode(String mVideoUrl) {
        return !TextUtils.isEmpty(mVideoUrl) && !mVideoUrl.startsWith("http") ?
                TimeKeeper.MODE_NATIVE_VIDEO : TimeKeeper.MODE_NET_VIDEO;
    }

    public boolean isPlayLocalVideo(String mVideoUrl) {
        return !TextUtils.isEmpty(mVideoUrl) && !mVideoUrl.startsWith("http");
    }

    protected void setRightViewVisible(boolean isVisible) {
        if (isVisible) {
            mRightLayout.setVisibility(View.VISIBLE);
            LayoutParams layoutParams = (LayoutParams) mRightLayout.getLayoutParams();
            layoutParams.height = LayoutParams.MATCH_PARENT;
            mRightLayout.setLayoutParams(layoutParams);
            mRightLayout.requestLayout();
            animatorHideQrCodeImage();
        } else {
            mRightLayout.setVisibility(View.GONE);
            if (mSpeedControlRootView != null) {
                mSpeedControlRootView.setVisibility(View.GONE);
            }
            if (mPlayDefinitionRootView != null) {
                mPlayDefinitionRootView.setVisibility(View.GONE);
            }
            if (mVideosListRootView != null) {
                mVideosListRootView.setVisibility(View.GONE);
            }
            if (!isTimerFinished) {
                animatorShowQrCodeImage();
            }
        }
    }

    private boolean isContentShow() {
        return (mContentPlayCompletionRootView != null &&
                mContentPlayCompletionRootView.getVisibility() == View.VISIBLE)
                || (mContentLoadVideoErrorView != null &&
                mContentLoadVideoErrorView.getVisibility() == View.VISIBLE)
                || (mContentMobileNetNoticeRootView != null &&
                mContentMobileNetNoticeRootView.getVisibility() == View.VISIBLE);
    }

    public boolean isVideoLocked() {
        return mLockVideoCbx != null && mLockVideoCbx.isChecked();
    }

    @Override
    public boolean performClick() {
        if (isContentShow()) {
            return false;
        } else {
            if (mRightLayout.getVisibility() == View.VISIBLE) {
                setRightViewVisible(false);
                return false;
            } else {
                return super.performClick();
            }
        }
    }

    @Override
    protected void performDoubleClick() {
        //判断是否有内容弹窗（讲义及完成view）弹出，如果没有则走正常流程，否则先按照弹窗交互
        if (!isContentShow()) {
            super.performDoubleClick();
            setPlayStatus(mCommonVideoView.isPlaying());
        }
    }

    public void pauseMediaByOtherClick() {
        if (mCommonVideoView != null && mCommonVideoView.isPlaying()) {
            performDoubleClickWithHide();
            setPlayStatus(mCommonVideoView.isPlaying());
        }
    }

    public void resumeMediaByOtherClick() {
        if (mCommonVideoView != null && !mCommonVideoView.isPlaying()) {
            performDoubleClickWithHide();
            setPlayStatus(mCommonVideoView.isPlaying());
        }
    }

    public void setPlayStatus(boolean isPlaying) {
        if (isPlaying) {
            mHorizontalStatusImg
                    .setImageResource(R.mipmap.pc_horizontal_media_controller_play_icon);
            mVerticalStatusImg.setImageResource(R.mipmap.pc_vertical_media_controller_play_icon);
        } else {
            mHorizontalStatusImg
                    .setImageResource(R.mipmap.pc_horizontal_media_controller_pause_icon);
            mVerticalStatusImg.setImageResource(R.mipmap.pc_vertical_media_controller_pause_icon);
        }
    }

    public void showLoadingVideoError() {
        hideFirstLoading();
        if (mContentLoadVideoErrorView == null) {
            LayoutInflater.from(mContext)
                    .inflate(R.layout.pc_course_video_loading_error_layout, mContentLayout, true);
            mContentLoadVideoErrorView =
                    mContentLayout.findViewById(R.id.course_video_loading_error_root_view);

            View retryPlayView =
                    mContentLayout.findViewById(R.id.course_video_loading_error_retry_view);

            retryPlayView.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (NetworkUtil.isNetworkAvailable(getContext())) {
                        setPlayVideoPath(true);
                    } else {
                        ToastUtil.showMessage(getContext(), "当前无网络！");
                    }
                }
            });
        } else {
            mContentLoadVideoErrorView.setVisibility(View.VISIBLE);
        }
        setContentViewVisible(true);
    }

    public void showLoadingMobileNetNotice() {
        pauseMediaByOtherClick();
        hideFirstLoading();
        if (mContentMobileNetNoticeRootView == null) {
            LayoutInflater.from(mContext)
                    .inflate(R.layout.pc_course_video_mobile_net_notice_layout, mContentLayout,
                            true);
            mContentMobileNetNoticeRootView =
                    mContentLayout.findViewById(R.id.course_video_mobile_net_notice_root_view);

            mContentMobileNetNoticeRootView.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {

                }
            });
            View continuePlayView =
                    mContentLayout.findViewById(R.id.course_video_mobile_net_continue_view);
            continuePlayView.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    ServiceFactory.getAppService().setIsAllowMobileNetPlayVideo(mContext,true);
                    setPlayVideoPath(true);
                }
            });
        }
        mContentMobileNetNoticeRootView.setVisibility(View.VISIBLE);
        setContentViewVisible(true);
    }

    protected void setContentViewVisible(boolean isVisible) {
        if (isVisible) {
            mContentLayout.setVisibility(View.VISIBLE);
        } else {
            mContentLayout.setVisibility(View.GONE);
            if (mContentPlayCompletionRootView != null) {
                mContentPlayCompletionRootView.setVisibility(View.GONE);
            }
//            if (mContentHomeworkEnterView != null) {
//                mContentHomeworkEnterView.setVisibility(View.GONE);
//            }
            if (mContentLoadVideoErrorView != null) {
                mContentLoadVideoErrorView.setVisibility(View.GONE);
            }
            if (mContentMobileNetNoticeRootView != null) {
                mContentMobileNetNoticeRootView.setVisibility(View.GONE);
            }
        }
    }

    /**
     * 显示 播放下一节、课后作业等view
     */
    public void showCompletionView() {
        BasePlayListItem playListItem = mPlayListController.getCurrentPlayItem();
        if (playListItem != null) {
        }
        setContentViewVisible(true);
    }

    @Override
    protected long preformUpdateProgress() {
        long current = super.preformUpdateProgress();
        Log.d(TAG,
                "preformUpdateProgress: " + current + "/" + mShowQrCodeIv + "/" + mQrCodeImageUrl);
        if (current / 1000 == QRCODE_SHOW_POSITION && mShowQrCodeIv &&
                !TextUtils.isEmpty(mQrCodeImageUrl)) {
            int count = PrefUtils.getCourseQrCodeShowCounts(mContext,mSecondCategory);
            PrefUtils.setCourseQrCodeShowCounts(mContext,mSecondCategory, count + 1);
            showQrCodeImage();
            mShowQrCodeIv = false;
        }
        return current;
    }

    private CountDownTimer mDownTimer;
    private boolean isTimerFinished;
    private boolean mShowQrCodeIv;
    private String mQrCodeImageUrl;
    private final static long QRCODE_SHOW_DURATION_IN_MILLIS = 20001;//20s
    private final static int QRCODE_SHOW_POSITION = 25;  //第25s

    public void setQrCodeImageUrl(String qrCodeImageUrl) {
        mQrCodeImageUrl = qrCodeImageUrl;
        mShowQrCodeIv = true;
    }

    /**
     * 显示课程二维码信息
     */
    private void showQrCodeImage() {
        Log.d(TAG, "showQrCodeImage: ");
        mQrCodeIv.setImageDrawable(null);
        mQrCodeIv.setVisibility(VISIBLE);
        Glide.with(getContext()).load(mQrCodeImageUrl).into(mQrCodeIv);
        if (mDownTimer != null) {
            mDownTimer.cancel();
            mDownTimer = null;
        }
        mDownTimer = new CountDownTimer(QRCODE_SHOW_DURATION_IN_MILLIS, 1000) {
            @Override
            public void onTick(long millisUntilFinished) {
            }

            @Override
            public void onFinish() {
                isTimerFinished = true;
                animatorHideQrCodeImage();
            }
        };
        isTimerFinished = false;
        mDownTimer.start();
    }

    public void hideQrCodeImageImmediately() {
        if (mDownTimer != null) {
            mDownTimer.cancel();
            mDownTimer = null;
        }
        mQrCodeIv.setVisibility(GONE);
    }

    public void setVideoPlayListView(boolean isVisible) {
        if (isVisible) {
            mVideosListShowView.setVisibility(View.VISIBLE);
        } else {
            mVideosListShowView.setVisibility(View.GONE);
        }
    }

    /**
     * 隐藏清晰度按钮
     */
    public void hideDefinitionView() {
        mCurrentPlayDefinitionView.setVisibility(View.GONE);
    }

    public void showDefinitionView() {
        mCurrentPlayDefinitionView.setVisibility(View.VISIBLE);
    }

    private boolean isShowSeeMoreButton = false;

    public void showSeeMoreButton() {
        isShowSeeMoreButton = true;
        mSeeMoreBtn.startAnimation(mRightInAnimation);
        mSeeMoreBtn.setVisibility(View.VISIBLE);
    }

    public void hideSeeMoreButton() {
        isShowSeeMoreButton = false;
//        mSeeMoreBtn.setVisibility(View.GONE);
        if (mSeeMoreBtn.getVisibility() == View.VISIBLE) {
            mSeeMoreBtn.startAnimation(mRightOutAnimation);
        }
    }

    private void animatorHideQrCodeImage() {
        if (mQrCodeIv.getVisibility() == GONE || mQrCodeIv.getVisibility() == INVISIBLE) {
            return;
        }
        Animation animation = AnimationUtils.loadAnimation(getContext(), R.anim.fade_out);
        mQrCodeIv.setAnimation(animation);
        animation.start();
        mQrCodeIv.setVisibility(GONE);
    }

    private void animatorShowQrCodeImage() {
        Animation animation = AnimationUtils.loadAnimation(getContext(), R.anim.fade_in);
        mQrCodeIv.setAnimation(animation);
        animation.start();
        mQrCodeIv.setVisibility(VISIBLE);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (signalDelayedHandler != null) {
            signalDelayedHandler.removeCallbacksAndMessages(null);
        }
    }

    public void startUploadVideoLog() {
        if (signalDelayedHandler != null &&
                !signalDelayedHandler.hasMessages(DUPLICATE_UPLOAD_VIDEO_LOG) &&
                NetworkUtil.isNetworkAvailable(mContext)) {
            signalDelayedHandler.sendSignalMessageDelayed(
                    signalDelayedHandler.obtainMessage(DUPLICATE_UPLOAD_VIDEO_LOG),
                    DUPLICATE_UPLOAD_TIME_INTERVAL);
        }
    }

    @Override
    protected void onHandleSignMessage(CommonVideoController reference, Message msg) {
        super.onHandleSignMessage(reference, msg);
        switch (msg.what) {
            case DUPLICATE_UPLOAD_VIDEO_LOG: {
                if (NetworkUtil.isNetworkAvailable(mContext) && mOnEventListener != null) {
                    mOnEventListener.onUploadByIntervalHandler();
                    signalDelayedHandler.sendSignalMessageDelayed(
                            signalDelayedHandler.obtainMessage(DUPLICATE_UPLOAD_VIDEO_LOG),
                            DUPLICATE_UPLOAD_TIME_INTERVAL);
                }
            }
            break;
            case DRAG_SEEKBAR_EVENT: {
                if (mOnEventListener != null) {
                    mOnEventListener.onStartDragSeekBar();
                }
            }
            break;
            default:
                break;
        }
    }

    public void setOnEventListener(OnEventListener onEventListener) {
        mOnEventListener = onEventListener;
    }

    public OnEventListener mOnEventListener;

    public interface OnEventListener {

        void onBackClick();

        void onUploadByIntervalHandler();

        /**
         * 全屏播放
         */
        void onFullScreenClick();

        void onNextPlayLessonClick(int position);

        void onStartDragSeekBar();

        void onSetLockEnable(boolean isLock);

        void onVideosItemListClick(int position);
    }

    private OnClickListener mSeeMoreClickListener;

    public void setSeeMoreClickListener(OnClickListener seeMoreClickListener) {
        mSeeMoreClickListener = seeMoreClickListener;
    }

    private Animation mRightInAnimation;
    private Animation mRightOutAnimation;
    private ObjectAnimator mBottomInAnimator, mBottomOutAnimator;

    private void initAnimation() {
        mRightInAnimation =
                AnimationUtils.loadAnimation(getContext(), android.R.anim.slide_in_left);
        mRightInAnimation.setDuration(mTopIn.getDuration());
        mRightOutAnimation =
                AnimationUtils.loadAnimation(getContext(), android.R.anim.slide_out_right);
        mRightOutAnimation.setAnimationListener(mRightOutAnimationListener);
        mRightOutAnimation.setDuration(mTopOut.getDuration());
        mBottomInAnimator =
                io.vov.vitamio.utils.AnimationUtils
                        .getBottomInAnimator(mContext, mBottomLayout, DEFAULT_ANIM_DURATION);
        mBottomOutAnimator =
                io.vov.vitamio.utils.AnimationUtils
                        .getBottomOutAnimator(mContext, mBottomLayout, DEFAULT_ANIM_DURATION);
    }

    private Animation.AnimationListener mRightOutAnimationListener =
            new Animation.AnimationListener() {

                @Override
                public void onAnimationStart(Animation animation) {

                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    mSeeMoreBtn.setVisibility(View.GONE);
                }

                @Override
                public void onAnimationRepeat(Animation animation) {

                }
            };

    @Override
    protected void onToolBarAnimationIn() {
        mTopMediaController.setVisibility(View.VISIBLE);
        mBottomMediaController.setVisibility(View.VISIBLE);
        mTopMediaController.startAnimation(mTopIn);
        mBottomInAnimator.start();

    }

    @Override
    protected void onToolBarAnimationOut() {
        mTopMediaController.startAnimation(mTopOut);
        mBottomOutAnimator.start();

    }

    @Override
    public void hideWithOutAnimation() {
        super.hideWithOutAnimation();
    }

    public BasePlayListItem getCurrentPlayListItem() {
        return mPlayListController.getCurrentPlayItem();
    }

    private OnCastViewClickListener mOnCastViewClickListener;

    public void setOnCastViewClickListener(OnCastViewClickListener onCastViewClickListener) {
        mOnCastViewClickListener = onCastViewClickListener;
    }

    /**
     * 投屏view事件
     */
    public interface OnCastViewClickListener {
        void onCastViewClicked(View view);
    }

    public void showCastView() {
        mTopCastView.setVisibility(View.VISIBLE);
    }

    public RelativeLayout getBottomLayout() {
        return mBottomLayout;
    }

    /**
     * 隐藏画中画视图
     */
    public void hidePipView() {
        if (mPortraitPipView != null) {
            mPortraitPipView.setVisibility(View.GONE);
        }
        if (mHorizontalPipView != null) {
            mHorizontalPipView.setVisibility(View.GONE);
        }
    }
}
