package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleInfo;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.edu24ol.newclass.discover.util.DiscoverViewUtil;
import com.hqwx.android.platform.widgets.CenterAlignImageSpan;

/**
 * Time:2022/3/18 11:11
 * Author:
 * Description:
 */
public interface DiscoverUISetterShortArticle {

    void refreshTitle(TextView showTotalContentView, TextView titleTextView,
                      ArticleInfo articleInfo, boolean isShowTag, int titleWidth);

    class NormalSetter implements DiscoverUISetterShortArticle {

        @Override
        public void refreshTitle(TextView showTotalContentView, TextView titleTextView, ArticleInfo articleInfo,
                                 boolean isShowTag, int titleWidth) {
            if (TextUtils.isEmpty(articleInfo.content)) {
                return;
            }
            String title;
            if (articleInfo.isStick()) {
                title = (isShowTag ? " " + " " : "") + articleInfo.content;
            } else {
                title = articleInfo.content;
            }
            SpannableString spannableString =
                addArticleTagToText(titleTextView.getContext(), articleInfo.isStick(), isShowTag, title);
            //判断是否需要显示查看更多
            String closeTextString = DiscoverArticleViewShort.getCloseTextContent(titleTextView,
                titleWidth, 5, spannableString.toString());
            if (TextUtils.isEmpty(closeTextString)) {
                showTotalContentView.setVisibility(View.GONE);
            } else {
                //显示查看更多，需要重新设置热门标签等
                spannableString =
                    addArticleTagToText(titleTextView.getContext(), articleInfo.isStick(), isShowTag, closeTextString);
                showTotalContentView.setVisibility(View.VISIBLE);
            }
            DiscoverArticleViewShort.setupTopicAndUserHighlight(articleInfo, spannableString);
            titleTextView.setText(spannableString);
        }

        protected SpannableString addArticleTagToText(Context context, boolean isStick,
                                                      boolean isShowTag, String textContent) {
            SpannableString newSpanString = new SpannableString(textContent);
            if (isStick && isShowTag) {
                CenterAlignImageSpan imageSpan =
                    DiscoverViewUtil.getImageSpanByDrawableId(context,
                        R.mipmap.discover_common_ic_stick_type);
                newSpanString.setSpan(imageSpan, 0, 1, Spannable.SPAN_INCLUSIVE_EXCLUSIVE);
            }
            return newSpanString;
        }
    }

    class ForwardSetter implements DiscoverUISetterShortArticle {

        @Override
        public void refreshTitle(TextView showTotalContentView, TextView titleTextView, ArticleInfo articleInfo,
                                 boolean isShowTag, int titleWidth) {
            if (TextUtils.isEmpty(articleInfo.content)) {
                return;
            }
            String title = "@" + (articleInfo.author != null ? articleInfo.author.name : "") + ":";
            int length = title.length();
            title = title + articleInfo.content;
            SpannableString spannableString;
            //判断是否需要显示查看更多
            String closeTextString = DiscoverArticleViewShort.getCloseTextContent(titleTextView,
                titleWidth, 5, title);
            if (TextUtils.isEmpty(closeTextString)) {
                spannableString = new SpannableString(title);
                showTotalContentView.setVisibility(View.GONE);
            } else {
                //显示查看更多，需要重新设置热门标签等
                // SpannableString newSpanString = addArticleTagToText(articleInfo.isStick(), isShowTag,
                //         closeTextString);
                spannableString = new SpannableString(closeTextString);
                showTotalContentView.setVisibility(View.VISIBLE);
            }
            DiscoverArticleViewShort.setupTopicAndUserHighlight(articleInfo, spannableString);
            spannableString.setSpan(new AtUserClickableSpan(articleInfo.getAuthorId()),
                0, length, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
            // spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#FF3965BC")),
            //         0, length, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
            titleTextView.setText(spannableString);
        }
    }

    class DetailSetter implements  DiscoverUISetterShortArticle {

        @Override
        public void refreshTitle(TextView showTotalContentView, TextView titleTextView,
                                 ArticleInfo articleInfo, boolean isShowTag, int titleWidth) {
            if (TextUtils.isEmpty(articleInfo.content)) {
                return;
            }
            String title= articleInfo.content;
            SpannableString spannableString = new SpannableString(title);
            DiscoverArticleViewShort.setupTopicAndUserHighlight(articleInfo, spannableString);
            titleTextView.setText(spannableString);
        }
    }

}
