package com.edu24ol.newclass.discover.widget.article;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.edu24ol.newclass.discover.util.DiscoverViewUtil;
import com.hqwx.android.platform.widgets.CenterAlignImageSpan;

/**
 * Time:2022/3/18 14:43
 * Author:
 * Description:
 */
public interface DiscoverUISetterLongArticle {

    void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag);

    class NormalSetter implements DiscoverUISetterLongArticle {

        @Override
        public void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            String title = articleInfo.title;

            SpannableString spannableString = null;
            // CenterAlignImageSpan articleImageSpan =
            //     DiscoverViewUtil.getImageSpanByDrawableId(titleView.getContext(),
            //         R.mipmap.discover_ic_long_article_type);
            if (articleInfo.isStick()) {
                if (isShowTag) {
                    CenterAlignImageSpan hotImageSpan =
                        DiscoverViewUtil.getImageSpanByDrawableId(titleView.getContext(),
                            R.mipmap.discover_common_ic_stick_type);
                    spannableString = new SpannableString(" " + " " + " " + title);
                    spannableString.setSpan(hotImageSpan, 0, 1, Spannable.SPAN_INCLUSIVE_EXCLUSIVE);

                    // spannableString.setSpan(articleImageSpan, 2, 3, Spannable.SPAN_INCLUSIVE_EXCLUSIVE);
                } else {
                    spannableString = new SpannableString(title);
                    // spannableString.setSpan(articleImageSpan, 0, 1, Spannable.SPAN_INCLUSIVE_EXCLUSIVE);
                }
            } else {
                spannableString = new SpannableString(title);
                // spannableString.setSpan(articleImageSpan, 0, 1, Spannable.SPAN_INCLUSIVE_EXCLUSIVE);
            }
            titleView.setText(spannableString);
        }
    }

    class ForwardSetter implements DiscoverUISetterLongArticle {

        @Override
        public void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            if (TextUtils.isEmpty(articleInfo.content)) {
                return;
            }
            String title = "";
            ArticleAuthor author = articleInfo.author;
            if(author != null){
                title = "@" + articleInfo.author.name + ":";
            }
            int length = title.length();
            title = title + articleInfo.title;
            SpannableString
                spannableString = new SpannableString(title);
            spannableString.setSpan(new AtUserClickableSpan(articleInfo.getAuthorId()),
                0, length, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
            titleView.setText(spannableString);
        }
    }

}
