package com.edu24ol.newclass.discover.widget.article;

import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;
import com.hqwx.android.platform.utils.StringUtils;

/**
 * Time:2022/3/18 15:02
 * Author:
 * Description:
 */
public interface DiscoverUISetterFAQArticle {

    void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag);

    void refreshContent(TextView showTotalContentView, TextView contentTextView,
                      ArticleInfo articleInfo, int textViewWidth);

    class NormalSetter implements DiscoverUISetterFAQArticle {

        @Override
        public void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            if (TextUtils.isEmpty(articleInfo.title)) {
                titleView.setVisibility(View.GONE);
            } else {
                titleView.setVisibility(View.VISIBLE);
                titleView.setText(articleInfo.title);
            }
        }

        @Override
        public void refreshContent(TextView showTotalContentView, TextView contentTextView,
                                   ArticleInfo articleInfo, int textViewWidth) {
            if (TextUtils.isEmpty(articleInfo.content)) {
                contentTextView.setText(StringUtils.EMPTY_STRING);
                return;
            }
            String title = articleInfo.content;

            //判断是否需要显示查看更多
            String closeTextString = DiscoverArticleViewShort.getCloseTextContent(contentTextView,
                    textViewWidth, 5, title);
            SpannableString spannableString;
            if (TextUtils.isEmpty(closeTextString)) {
                spannableString = new SpannableString(title);
                showTotalContentView.setVisibility(View.GONE);
            } else {
                spannableString = new SpannableString(closeTextString);
                showTotalContentView.setVisibility(View.VISIBLE);
            }
            DiscoverArticleViewShort.setupTopicAndUserHighlight(articleInfo, spannableString);
            contentTextView.setText(spannableString);
        }
    }

    class ForwardSetter extends NormalSetter {

        @Override
        public void refreshTitle(TextView titleView, ArticleInfo articleInfo, boolean isShowTag) {
            String title = "";
            ArticleAuthor author = articleInfo.author;
            if (author != null) {
                title = "@" + articleInfo.author.name + ":";
            }
            int length = title.length();
            if (!TextUtils.isEmpty(articleInfo.title)) {
                title = title + articleInfo.title;
            }
            SpannableString
                    spannableString = new SpannableString(title);
            spannableString.setSpan(new AtUserClickableSpan(articleInfo.getAuthorId()),
                    0, length, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
            titleView.setText(spannableString);
            titleView.setVisibility(View.VISIBLE);
        }
    }
}
