package com.edu24ol.newclass.discover.widget.article;

import android.text.SpannableString;
import android.text.Spanned;
import android.view.View;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.text.AtUserClickableSpan;

/**
 * Time:2022/3/18 15:02
 * Author:
 * Description:
 */
public interface DiscoverUISetterCommentArticle {

    void refreshForwardTitle(TextView titleView, ArticleInfo articleInfo);

    class NormalSetter implements DiscoverUISetterCommentArticle {

        @Override
        public void refreshForwardTitle(TextView titleView, ArticleInfo articleInfo) {
            titleView.setVisibility(View.GONE);
        }
    }

    class ForwardSetter implements DiscoverUISetterCommentArticle {

        @Override
        public void refreshForwardTitle(TextView titleView, ArticleInfo articleInfo) {
            ArticleAuthor author = articleInfo.author;
            if (author != null) {
                String title = "@" + articleInfo.author.name + ":";
                titleView.setVisibility(View.VISIBLE);
                int length = title.length();
                SpannableString
                    spannableString = new SpannableString(title);
                spannableString.setSpan(new AtUserClickableSpan(articleInfo.getAuthorId()),
                    0, length, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
                titleView.setText(spannableString);
            } else {
                titleView.setVisibility(View.GONE);
            }
        }
    }
}
