package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleTopic;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.discover.common.databinding.DiscoverItemTopicContentViewBinding;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.widgets.AbstractBaseRecycleViewAdapter;
import com.hqwx.android.platform.widgets.flowlayout.FlowLayoutManager;

import org.jetbrains.annotations.NotNull;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Time:2022/3/15 18:25
 * Author: heyangbin
 * Description: 发现社区 话题显示区域
 */
public class DiscoverTopicContentView extends ConstraintLayout {

    private DiscoverItemTopicContentViewBinding mBinding;

    private TopicAdapter mTopicAdapter;

    public DiscoverTopicContentView(
        @NonNull @NotNull Context context) {
        this(context, null);
    }

    public DiscoverTopicContentView(@NonNull @NotNull Context context,
                                    @Nullable @org.jetbrains.annotations.Nullable
                                        AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DiscoverTopicContentView(@NonNull @NotNull Context context,
                                    @Nullable @org.jetbrains.annotations.Nullable AttributeSet attrs,
                                    int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mBinding = DiscoverItemTopicContentViewBinding.inflate(LayoutInflater.from(context), this);
        mBinding.recyclerView.setLayoutManager(new FlowLayoutManager());
        mBinding.recyclerView.addItemDecoration(new SpaceItemDecoration(DisplayUtils.dip2px(getContext(), 8)));
        mTopicAdapter = new TopicAdapter(context);
        mBinding.recyclerView.setAdapter(mTopicAdapter);
    }

    public void setTopicData(List<ArticleTopic> topicList){
        mTopicAdapter.setData(topicList);
        mTopicAdapter.notifyDataSetChanged();
    }

    private OnClickListener mTopicClickListener;

    public void setTopicClickListener(OnClickListener topicClickListener) {
        mTopicClickListener = topicClickListener;
    }

    protected class TopicAdapter extends AbstractBaseRecycleViewAdapter<ArticleTopic> {

        public TopicAdapter(Context context) {
            super(context);
        }

        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(LayoutInflater.from(mContext)
                .inflate(R.layout.discover_item_topic, parent, false));
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            TextView textView = (TextView) holder.itemView;
            ArticleTopic topic = getItem(position);
            textView.setText("#" + topic.getTopicName());
            textView.setTag(topic);
        }

        private class ViewHolder extends RecyclerView.ViewHolder {

            public ViewHolder(@NonNull View itemView) {
                super(itemView);
                itemView.setOnClickListener(view -> {
                    if (mTopicClickListener != null) {
                        mTopicClickListener.onClick(view);
                    }
                });
            }
        }
    }

    private class SpaceItemDecoration extends RecyclerView.ItemDecoration {

        private int space;

        public SpaceItemDecoration(int space) {
            this.space = space;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent,
                                   RecyclerView.State state) {
            outRect.right = space;
            outRect.bottom = space;
        }
    }
}
