package com.edu24ol.newclass.discover.widget.article

import android.content.Context
import android.graphics.Paint
import android.text.Spannable
import android.text.SpannableString
import android.text.SpannableStringBuilder
import android.text.TextUtils
import android.util.AttributeSet
import android.view.LayoutInflater
import androidx.constraintlayout.widget.ConstraintLayout
import com.edu24.data.server.entity.GoodsGroupListBean
import com.hqwx.android.discover.common.R
import com.hqwx.android.discover.common.databinding.DiscoverRecommendCourseLayoutBinding
import com.hqwx.android.platform.kt.ext.isNotNullAndNotEmpty
import com.hqwx.android.platform.utils.DisplayUtils
import com.hqwx.android.platform.widgets.text.IconTextSpan
import kotlin.math.min

/**
 * Time:2022/3/15 14:02
 * Author:
 * Description:
 */
class DiscoverGoodsView : ConstraintLayout {
    private var mBinding: DiscoverRecommendCourseLayoutBinding =
        DiscoverRecommendCourseLayoutBinding.inflate(LayoutInflater.from(context), this, true)

    init {
        mBinding.textCourseName.paint.isFakeBoldText = true
    }

    constructor(
        context: Context
    ) : this(context, null) {
    }

    constructor(
        context: Context,
        attrs: AttributeSet?
    ) : this(context, attrs, 0) {
    }

    constructor(
        context: Context,
        attrs: AttributeSet?, defStyleAttr: Int
    ) : super(context, attrs, defStyleAttr) {
    }

    fun refreshCardView(bean: GoodsGroupListBean) {
        mBinding.root.tag = bean
        if (TextUtils.isEmpty(bean.secondCategoryName)) {
            mBinding.textCourseName.text = bean.name
        } else {
            val paint: Paint = mBinding.textCourseName.paint
            val textSize = paint.textSize
            paint.textSize = textSize
            val builder = SpannableStringBuilder()
            var spannableString = SpannableString(bean.secondCategoryName)
            var backgroundColorSpan = IconTextSpan(
                context,
                R.color.discover_common_gcv_theme_category_text_color, bean.secondCategoryName,
                DisplayUtils.dip2px(context, 16f).toFloat()
            )
            backgroundColorSpan.setRadius(DisplayUtils.dip2px(context, 2f).toFloat())
            backgroundColorSpan.setRightMarginDpValue(4)
            spannableString.setSpan(
                backgroundColorSpan, 0, bean.secondCategoryName.length,
                Spannable.SPAN_INCLUSIVE_EXCLUSIVE
            )
            builder.append(spannableString)
            builder.append(bean.name)
            mBinding.textCourseName.text = builder
        }
        //卖点最多三个
        val builder = StringBuilder()
        if (bean.teachers.isNotNullAndNotEmpty()) {
            bean.teachers.forEach { teachersBean ->
                builder.append(teachersBean.name + " · ")
            }
        }
        builder.append("共" + bean.lessonCount + "次课 ")
        if (bean.isSellPointNotEmpty) {
            for (i in 0 until min(bean.sellPoint.size, 3)) {
                builder.append(" · ").append(bean.sellPoint[i])
            }
        }
        mBinding.classCountSellPoint.text = builder
    }
}