package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleInfo;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.util.DiscoverSpanStringUtil;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class DiscoverForwardContentView extends LinearLayout {

    protected TextView mForwardContentText;

    public DiscoverForwardContentView(@NonNull Context context) {
        this(context, null);
    }

    public DiscoverForwardContentView(@NonNull Context context,
                                      @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DiscoverForwardContentView(@NonNull Context context, @Nullable AttributeSet attrs,
                                      int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initViews();
    }

    protected void initViews() {
        setOrientation(LinearLayout.VERTICAL);
        View itemView =
            LayoutInflater.from(getContext()).inflate(getContentLayoutId(), this, true);
        mForwardContentText = itemView.findViewById(R.id.text_content);
        setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutId() {
        return R.layout.discover_common_forward_content_layout;
    }

    public void refreshForwardContent(ArticleInfo articleInfo) {
        if (mForwardContentText == null) {
            return;
        }
        if (TextUtils.isEmpty(articleInfo.content)) {
            return;
        }
        String title = articleInfo.content;
        SpannableString spannableString = new SpannableString(title);
        DiscoverSpanStringUtil
            .setStringArticleTopicHighlight(spannableString, articleInfo.getArticleTopics());
        DiscoverSpanStringUtil
            .setStringArticleUserHighlight(spannableString, articleInfo.getArticleATUsers());
        mForwardContentText.setText(spannableString);
    }

}
