package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.request.RequestOptions;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.util.RatioUtil;
import com.edu24ol.newclass.discover.widget.DefaultImageViewTarget;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.glide.tranform.SafeRoundedCorners;
import com.hqwx.android.playercontroller.ListVideoItemView;
import com.hqwx.android.service.ServiceFactory;
import com.hqwx.android.service.difference.DifferenceConfig;
import com.yy.android.educommon.utils.TimeUtils;

public class DiscoverArticleViewVideo
        extends ConstraintLayout implements IArticleView<DiscoverArticleViewVideo> {

    //封面
    protected ImageView mRecommendImg;

    TextView mVideoDurationTv;

    TextView mTitleView;

    private int mPictureRoundRadius;

    ListVideoItemView mListVideoItemView;

    protected DiscoverUISetterVideoArticle mUISetter;

    public DiscoverArticleViewVideo(@NonNull Context context) {
        super(context);
        initViews();
    }

    public DiscoverArticleViewVideo(@NonNull Context context,
                                    @Nullable AttributeSet attrs) {
        super(context, attrs);
        initViews();
    }

    public DiscoverArticleViewVideo(@NonNull Context context, @Nullable AttributeSet attrs,
                                    int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initViews();
    }

    public void setUISetter(
        DiscoverUISetterVideoArticle uiSetterVideoArticle) {
        mUISetter = uiSetterVideoArticle;
    }

    protected void initViews() {
        View itemView =
            LayoutInflater
                .from(getContext()).inflate(getContentLayoutId(), this, true);
        mRecommendImg = itemView.findViewById(R.id.item_discover_recommend_img);
        mPictureRoundRadius = DisplayUtils.dip2px(getContext(), 2);
        mTitleView = itemView.findViewById(R.id.item_discover_recommend_title_view);
        mVideoDurationTv = itemView.findViewById(R.id.tv_video_duration);
        setViewParams();
        mListVideoItemView = findViewById(R.id.item_video_view);
    }

    protected void setViewParams() {
        int paddingLeft = getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutId() {
        return R.layout.discover_item_article_view_video;
    }

    public void refreshArticleVideoContent(ArticleInfo articleInfo, int position) {
        if(DifferenceConfig.discoverDifferenceService.fixHeightVideoShow()){

            Pair<Integer, Integer> ratioPair = null;
            if(articleInfo.isVideoVerticalRatio()&&articleInfo.isCoverVerticalRatio()){
                int videoHeight = articleInfo.getVideoHeight();
                int videoWidth = articleInfo.getVideoWidth();
                ratioPair= RatioUtil.fixRatioUtil(getContext(), videoWidth, videoHeight);
            }else{
                int screenWidth = DisplayUtils.getScreenWidth(getContext());
                int height = (int) (screenWidth * 194.f / 345f);
                ratioPair = RatioUtil.fixRatioUtil(getContext(), screenWidth, height);
            }
            int width = ratioPair.first;
            int height = ratioPair.second;
            ViewGroup.LayoutParams layoutParams = mListVideoItemView.getLayoutParams();
            if(layoutParams!=null){
                layoutParams.height = height;
                layoutParams.width = width;
            }
            ViewGroup.LayoutParams coverLayoutParams = mRecommendImg.getLayoutParams();
            if(coverLayoutParams!=null){
                coverLayoutParams.height = height;
                coverLayoutParams.width = width;
            }
        }


        mVideoDurationTv
            .setText(TimeUtils.makeTimeString(getContext(), articleInfo.getVideoDuration()));
        if (!TextUtils.isEmpty(articleInfo.getVideoCover())) {
            mRecommendImg
                .setVisibility(View.VISIBLE);
            Glide.with(getContext()).load(articleInfo.getVideoCover())
                .transform(new CenterCrop(), new SafeRoundedCorners(mPictureRoundRadius))
                .apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.ALL).dontAnimate())
                .into(new DefaultImageViewTarget(mRecommendImg));
        }
        mListVideoItemView.setName(articleInfo.getVideoTitle());
        mListVideoItemView.setListPosition(position);
        mListVideoItemView.setTag(R.id.tag_position, position);
        mListVideoItemView.setTag(articleInfo);
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (mUISetter == null) {
            mUISetter = new DiscoverUISetterVideoArticle.NormalSetter();
        }
        mUISetter.setupVideoTitleView(mTitleView, articleInfo, isShowTag);
        refreshArticleVideoContent(articleInfo, position);
    }

    @Override
    public void setArticleEventListener(IArticleEventListener eventListener) {

    }

    @Override
    public void setViewVisible(boolean show) {
        setVisibility(show ? View.VISIBLE : View.GONE);
    }

    @Override
    public void setForwardUISetter() {
        setUISetter(new DiscoverUISetterVideoArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewVideo getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return mTitleView;
    }

}
