package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.Layout;
import android.text.Spannable;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;

import com.edu24.data.server.discover.entity.ArticleImage;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.entity.GoodsGroupListBean;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.util.DiscoverSpanStringUtil;
import com.edu24ol.newclass.discover.widget.ShortArticlePictureView;
import com.edu24ol.newclass.discover.widget.TextViewFixTouchConsume;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.yy.android.educommon.log.YLog;

import java.util.List;

public class DiscoverArticleViewShort extends ConstraintLayout
        implements IArticleView<DiscoverArticleViewShort> {

    private DiscoverUISetterShortArticle mUISetter;

    public DiscoverArticleViewShort(@NonNull Context context) {
        super(context);
        initViews();
    }

    public DiscoverArticleViewShort(@NonNull Context context,
                                    @Nullable AttributeSet attrs) {
        super(context, attrs);
        initViews();
    }

    public DiscoverArticleViewShort(@NonNull Context context, @Nullable AttributeSet attrs,
                                    int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initViews();
    }

    public void setUISetter(
            DiscoverUISetterShortArticle UISetter) {
        mUISetter = UISetter;
    }

    protected TextViewFixTouchConsume mShortContentTitleView;
    protected TextView mShowTotalContentView;
    protected ShortArticlePictureView mShortArticlePictureView;
    protected DiscoverGoodsView mRecommendCourseView;
    protected int mShortDiscoverTitleWidth;

    protected void initViews() {
        View itemView =
                LayoutInflater.from(getContext()).inflate(getContentLayoutResourceId(), this, true);
        mShortContentTitleView = itemView.findViewById(R.id.item_discover_short_title_view);
        mShortContentTitleView.setMovementMethod(
                TextViewFixTouchConsume.LocalLinkMovementMethod.getInstance());
        mShortContentTitleView.setFocusable(false);
        mShowTotalContentView = itemView.findViewById(R.id.item_discover_short_show_total_view);
        mShortArticlePictureView = itemView.findViewById(R.id.picture_view);
        mShortArticlePictureView.setFocusableInTouchMode(false);
        mShortArticlePictureView.requestFocus();
        mRecommendCourseView =
                itemView.findViewById(R.id.item_discover_recommend_course_root_view);

        mRecommendCourseView.setOnClickListener(view -> {
            if (mArticleEventListener != null) {
                mArticleEventListener.onRecommendCourseClick((GoodsGroupListBean) view.getTag());
            }
        });
        mShortDiscoverTitleWidth =
                DisplayUtils.getScreenWidth(getContext()) -
                        getContext().getResources()
                                .getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;
        setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = getContext().getResources()
                .getDimensionPixelSize(R.dimen.platform_common_margin_size);
        setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutResourceId() {
        return R.layout.discover_item_article_view_short;
    }

    protected void showShortCourseView(final ArticleInfo articleInfo) {
        if (articleInfo.goodsList != null && articleInfo.goodsList.size() > 0) {
            mRecommendCourseView.refreshCardView(articleInfo.goodsList.get(0));
            mRecommendCourseView.setVisibility(View.VISIBLE);
            mRecommendCourseView.setTag(articleInfo.goodsList.get(0));
        } else {
            mRecommendCourseView.setVisibility(View.GONE);
        }
    }

    protected void showShortPicView(final ArticleInfo articleInfo) {
        List<ArticleImage> shortArticlePictures = articleInfo.shortArticlePictures;
        if (shortArticlePictures != null && shortArticlePictures.size() > 0) {
            mShortArticlePictureView.setVisibility(View.VISIBLE);
            mShortArticlePictureView.setPicture(shortArticlePictures);
        } else {
            mShortArticlePictureView.setVisibility(View.GONE);
        }
    }

    public void refreshTitle(final ArticleInfo articleInfo, boolean isShowTag) {
        if (mUISetter == null) {
            mUISetter = new DiscoverUISetterShortArticle.NormalSetter();
        }
        mUISetter.refreshTitle(mShowTotalContentView, mShortContentTitleView,
                articleInfo, isShowTag, mShortDiscoverTitleWidth);
    }

    /**
     * 设置话题和@用户高亮
     *
     * @param articleInfo
     */
    public static void setupTopicAndUserHighlight(final ArticleInfo articleInfo,
                                                  Spannable spannable) {
        DiscoverSpanStringUtil
                .setStringArticleTopicHighlight(spannable, articleInfo.getArticleTopics());
        DiscoverSpanStringUtil
                .setStringArticleUserHighlight(spannable, articleInfo.getArticleATUsers());
    }

    /**
     * @param tv
     * @param textViewLineWidth textView的宽度
     * @param maxLine           最多几行
     * @param content
     * @return
     */
    @Nullable
    @CheckResult
    public static String getCloseTextContent(TextView tv, int textViewLineWidth, int maxLine,
                                             String content) {
        if (textViewLineWidth < 0) {
            YLog.warn("", "getCloseTextContent error,width: %d", textViewLineWidth);
            return null;
        }
        int maxOffset = 8;
        TextPaint paint = tv.getPaint();
        //每行文本的布局宽度
        //实例化StaticLayout 传入相应参数
        StaticLayout staticLayout =
            new StaticLayout(content, paint, textViewLineWidth, Layout.Alignment.ALIGN_NORMAL,
                tv.getLineSpacingMultiplier(), 0, false);
        //判断content是行数是否超过最大限制行数
        if (staticLayout.getLineCount() > maxLine) {
            //最后一行的文字
            String lineText = content.substring(staticLayout.getLineStart(maxLine - 1),
                    staticLayout.getLineStart(maxLine));
            //文字宽度
            float textWidth = paint.measureText(lineText);
            int offset = 0;
            float ratio = textWidth / textViewLineWidth;
            if (ratio > 0.6f) {
                offset = (int) (maxOffset * ratio);
            }
            int index = staticLayout.getLineStart(maxLine);
            try {
                //定义收起后的文本内容
                return content.substring(0, index - offset).trim() +
                        "...";
            } catch (StringIndexOutOfBoundsException e) {
                YLog.error("", "getCloseTextContent: ", e);
                return null;
            }
        } else {
            return null;
        }
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (mUISetter == null) {
            mUISetter = new DiscoverUISetterShortArticle.NormalSetter();
        }
        refreshTitle(articleInfo, isShowTag);
        showShortPicView(articleInfo);
        showShortCourseView(articleInfo);
    }

    private ArticleEventListener mArticleEventListener;

    @Override
    public void setArticleEventListener(IArticleEventListener eventListener) {
        mArticleEventListener = (ArticleEventListener) eventListener;
    }

    public interface ArticleEventListener extends IArticleEventListener {

        void onRecommendCourseClick(GoodsGroupListBean groupListBean);

    }

    @Override
    public void setViewVisible(boolean show) {
        setVisibility(show ? View.VISIBLE : View.GONE);
    }

    @Override
    public void setForwardUISetter() {
        setUISetter(new DiscoverUISetterShortArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewShort getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return mShortContentTitleView;
    }
   
    public TextView getTotalContentView() {
        return mShowTotalContentView;
    }

}
