package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.request.RequestOptions;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.widget.DefaultImageViewTarget;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.glide.tranform.SafeRoundedCorners;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;

public class DiscoverArticleViewLong
        extends ConstraintLayout implements IArticleView<DiscoverArticleViewLong> {

    //封面
    protected ImageView mRecommendImg;
    protected TextView mDiscoverLongTitleView;
    protected TextView mSummary;
    private int mPictureRoundRadius;

    private DiscoverUISetterLongArticle mUISetterLongArticle;

    public DiscoverArticleViewLong(@NonNull Context context) {
        super(context);
        initViews();
    }

    public DiscoverArticleViewLong(@NonNull Context context,
                                   @Nullable AttributeSet attrs) {
        super(context, attrs);
        initViews();
    }

    public DiscoverArticleViewLong(@NonNull Context context, @Nullable AttributeSet attrs,
                                   int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initViews();
    }

    public void setUISetter(
        DiscoverUISetterLongArticle UISetterLongArticle) {
        mUISetterLongArticle = UISetterLongArticle;
    }

    protected void initViews() {
        View itemView =
            LayoutInflater.from(getContext()).inflate(getContentLayoutId(), this, true);
        mRecommendImg = itemView.findViewById(R.id.item_discover_recommend_img);
        mDiscoverLongTitleView = itemView.findViewById(R.id.item_discover_recommend_title_view);
        mSummary = itemView.findViewById(R.id.item_discover_recommend_summary);
        mPictureRoundRadius = DisplayUtils.dip2px(getContext(), 2);
        setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutId() {
        return R.layout.discover_item_article_view_long;
    }

    protected void refreshArticleContent(ArticleInfo articleInfo) {
        if (!TextUtils.isEmpty(articleInfo.longPic)) {
            mRecommendImg.setVisibility(View.VISIBLE);
            Glide.with(getContext()).load(articleInfo.longPic)
                .apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.ALL)
                    .dontAnimate())
                .transform(new CenterCrop(), new SafeRoundedCorners(mPictureRoundRadius))
                .into(new DefaultImageViewTarget(mRecommendImg));
            mSummary.setVisibility(View.GONE);
        } else {
            if (!TextUtils.isEmpty(articleInfo.summary)) {
                mSummary.setVisibility(View.VISIBLE);
                mSummary.setText(articleInfo.summary);
            } else {
                mSummary.setVisibility(View.GONE);
            }
            mRecommendImg.setVisibility(View.GONE);
        }
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (mUISetterLongArticle == null) {
            mUISetterLongArticle = new DiscoverUISetterLongArticle.NormalSetter();
        }
        refreshArticleContent(articleInfo);
        mUISetterLongArticle.refreshTitle(mDiscoverLongTitleView, articleInfo, isShowTag);
    }

    @Override
    public void setArticleEventListener(IArticleEventListener eventListener) {

    }

    @Override
    public void setViewVisible(boolean show) {
        setVisibility(show ? View.VISIBLE : View.GONE);
    }

    @Override
    public void setForwardUISetter() {
        setUISetter(new DiscoverUISetterLongArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewLong getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return mDiscoverLongTitleView;
    }

}
