package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleImage;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.widget.ShortArticlePictureView;
import com.edu24ol.newclass.discover.widget.TextViewFixTouchConsume;
import com.hqwx.android.platform.utils.DisplayUtils;
import java.util.List;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;

public class DiscoverArticleViewFAQ extends ConstraintLayout
    implements IArticleView<DiscoverArticleViewFAQ> {

    private DiscoverUISetterFAQArticle mUISetter;

    public DiscoverArticleViewFAQ(@NonNull Context context) {
        super(context);
        initViews();
    }

    public DiscoverArticleViewFAQ(@NonNull Context context,
                                  @Nullable AttributeSet attrs) {
        super(context, attrs);
        initViews();
    }

    public DiscoverArticleViewFAQ(@NonNull Context context, @Nullable AttributeSet attrs,
                                  int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initViews();
    }

    public void setUISetter(
        DiscoverUISetterFAQArticle UISetterShortArticle) {
        mUISetter = UISetterShortArticle;
    }

    protected TextView mTitleView;
    protected TextView mQuestionContentView;
    protected TextView mAnswerContentView;
    protected ShortArticlePictureView mShortArticlePictureView;
    protected TextView mShowTotalContentView;
    protected int mShortDiscoverTitleWidth;

    protected void initViews() {
        View itemView =
            LayoutInflater.from(getContext()).inflate(getContentLayoutResourceId(), this, true);
        mTitleView = itemView.findViewById(R.id.title_view);
        mQuestionContentView = itemView.findViewById(R.id.question_content_view);
        mAnswerContentView = itemView.findViewById(R.id.answer_content_view);
        mShortArticlePictureView = itemView.findViewById(R.id.picture_view);

        mShortArticlePictureView.setFocusableInTouchMode(false);
        mShortArticlePictureView.requestFocus();

        mShowTotalContentView = itemView.findViewById(R.id.show_total_view);
        mShortDiscoverTitleWidth =
                DisplayUtils.getScreenWidth(getContext()) -
                        getContext().getResources()
                                .getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;

        setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = getContext().getResources()
            .getDimensionPixelSize(R.dimen.platform_common_margin_size);
        setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutResourceId() {
        return R.layout.discover_item_article_view_faq;
    }

    protected void showPictureView(final ArticleInfo articleInfo) {
        List<ArticleImage> shortArticlePictures = articleInfo.shortArticlePictures;
        if (shortArticlePictures != null && shortArticlePictures.size() > 0) {
            mShortArticlePictureView.setVisibility(View.VISIBLE);
            mShortArticlePictureView.setPicture(shortArticlePictures);
        } else {
            mShortArticlePictureView.setVisibility(View.GONE);
        }
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (mUISetter == null) {
            mUISetter = new DiscoverUISetterFAQArticle.NormalSetter();
        }
        mUISetter.refreshTitle(mTitleView, articleInfo, isShowTag);
        mUISetter.refreshContent(mShowTotalContentView, mQuestionContentView, articleInfo, mShortDiscoverTitleWidth);
        showPictureView(articleInfo);
        if (articleInfo.getArticleFAQ() != null) {
            mAnswerContentView.setText("教研老师： " + articleInfo.getArticleFAQ().getContentText());
            mAnswerContentView.setVisibility(View.VISIBLE);
        } else {
            mAnswerContentView.setVisibility(View.GONE);
        }
    }

    private DiscoverArticleViewShort.ArticleEventListener mArticleEventListener;

    @Override
    public void setArticleEventListener(IArticleEventListener eventListener) {
        mArticleEventListener = (DiscoverArticleViewShort.ArticleEventListener) eventListener;
    }

    public interface ArticleEventListener extends IArticleEventListener {

    }

    @Override
    public void setViewVisible(boolean show) {
        setVisibility(show ? View.VISIBLE : View.GONE);
    }

    @Override
    public void setForwardUISetter() {
        setUISetter(new DiscoverUISetterFAQArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewFAQ getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return null;
    }

}
