package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleInfo;
import com.hqwx.android.discover.common.R;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class DiscoverArticleViewDelete extends LinearLayout implements IArticleView<DiscoverArticleViewDelete> {

    public DiscoverArticleViewDelete(@NonNull Context context) {
        super(context);
        initViews();
    }

    public DiscoverArticleViewDelete(@NonNull Context context,
                                     @Nullable AttributeSet attrs) {
        super(context, attrs);
        initViews();
    }

    public DiscoverArticleViewDelete(@NonNull Context context, @Nullable AttributeSet attrs,
                                     int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initViews();
    }

    protected void initViews() {
        View itemView =
            LayoutInflater.from(getContext()).inflate(getContentLayoutId(), this, true);
        setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutId() {
        return R.layout.discover_item_article_view_delete;
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
    }

    @Override
    public void setArticleEventListener(IArticleEventListener eventListener) {

    }

    @Override
    public void setViewVisible(boolean show) {
        setVisibility(show ? View.VISIBLE : View.GONE);
    }

    @Override
    public void setForwardUISetter() {
    }

    @Override
    public DiscoverArticleViewDelete getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return null;
    }

}
