package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.entity.GoodsGroupListBean;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.widgets.ratingbar.AndRatingBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;

public class DiscoverArticleViewComment
        extends ConstraintLayout implements IArticleView<DiscoverArticleViewComment> {

    private DiscoverUISetterCommentArticle mUISetter;

    public DiscoverArticleViewComment(@NonNull Context context) {
        super(context);
        initViews();
    }

    public DiscoverArticleViewComment(@NonNull Context context,
                                      @Nullable AttributeSet attrs) {
        super(context, attrs);
        initViews();
    }

    public DiscoverArticleViewComment(@NonNull Context context, @Nullable AttributeSet attrs,
                                      int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initViews();
    }

    public void setUISetter(
        DiscoverUISetterCommentArticle UISetter) {
        mUISetter = UISetter;
    }

    protected TextView mForwardTextView;
    protected TextView mTitleView;
    protected TextView mContentView;
    protected DiscoverGoodsView mCommentCourseView;
    protected AndRatingBar mRatingBar;

    protected void initViews() {
        View itemView =
            LayoutInflater.from(getContext()).inflate(getContentLayoutResourceId(), this, true);
        mForwardTextView = itemView.findViewById(R.id.forward_text_view);
        mTitleView = itemView.findViewById(R.id.title_view);
        mContentView = itemView.findViewById(R.id.content_view);
        mRatingBar = itemView.findViewById(R.id.rb_course_evaluate);
        mCommentCourseView =
            itemView.findViewById(R.id.course_root_view);

        mCommentCourseView.setOnClickListener(view -> {
            if (mArticleEventListener != null) {
                mArticleEventListener.onCourseClick((GoodsGroupListBean) view.getTag());
            }
        });
        mRatingBar.setIsIndicator(true);
        setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = getContext().getResources().getDimensionPixelSize(R.dimen.platform_common_margin_size);
        setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected int getContentLayoutResourceId() {
        return R.layout.discover_item_article_view_comment;
    }

    protected void showShortCourseView(final ArticleInfo articleInfo) {
        if (articleInfo.commentGoods != null && articleInfo.commentGoods.size() > 0) {
            mCommentCourseView.refreshCardView(articleInfo.commentGoods.get(0));
            mCommentCourseView.setVisibility(View.VISIBLE);
            mCommentCourseView.setTag(articleInfo.commentGoods.get(0));
        } else {
            mCommentCourseView.setVisibility(View.GONE);
        }
    }

    @Override
    public void refreshArticleInfo(ArticleInfo articleInfo, int position, boolean isShowTag) {
        if (mUISetter == null) {
            mUISetter = new DiscoverUISetterCommentArticle.NormalSetter();
        }
        mUISetter.refreshForwardTitle(mForwardTextView, articleInfo);
        if(articleInfo.getArticleCourseComment() != null){
            mRatingBar.setRating(articleInfo.getArticleCourseComment().getStar());
        }
        mContentView.setText(articleInfo.content);
        showShortCourseView(articleInfo);
    }

    private ArticleEventListener mArticleEventListener;

    @Override
    public void setArticleEventListener(IArticleEventListener eventListener) {
        mArticleEventListener = (ArticleEventListener) eventListener;
    }

    public interface ArticleEventListener extends IArticleEventListener {

        void onCourseClick(GoodsGroupListBean groupListBean);

    }

    @Override
    public void setViewVisible(boolean show) {
        setVisibility(show ? View.VISIBLE : View.GONE);
    }

    @Override
    public void setForwardUISetter() {
        setUISetter(new DiscoverUISetterCommentArticle.ForwardSetter());
    }

    @Override
    public DiscoverArticleViewComment getRoot() {
        return this;
    }

    @Override
    public TextView getContentView() {
        return null;
    }

}
