package com.edu24ol.newclass.discover.widget.article;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.discover.entity.ArticleTopic;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.widget.ImageCountFuncView;
import com.hqwx.android.service.ServiceFactory;
import com.hqwx.android.service.difference.DifferenceConfig;

import org.jetbrains.annotations.NotNull;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.List;

/**
 * Time:2022/3/17 11:46
 * Author:
 * Description: 文章底部工具栏View
 */
public class DiscoverArticleFooterView extends LinearLayout {

    protected ImageCountFuncView mShareFuncView;
    // protected ImageCountFuncView mForwardFuncView;
    protected ImageCountFuncView mEvaluateFuncView;
    protected ImageCountFuncView mPraiseFuncView;

    protected DiscoverTopicContentView mDiscoverTopicContentView;

    protected boolean isEnableTopic = true;

    public DiscoverArticleFooterView(
            @NonNull @NotNull Context context) {
        this(context, null);
    }

    public DiscoverArticleFooterView(@NonNull @NotNull Context context,
                                     @Nullable @org.jetbrains.annotations.Nullable
                                             AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DiscoverArticleFooterView(@NonNull @NotNull Context context,
                                     @Nullable @org.jetbrains.annotations.Nullable
                                             AttributeSet attrs,
                                     int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
        setViewParams();
    }

    protected void setViewParams() {
        int paddingLeft = getContext().getResources()
                .getDimensionPixelSize(R.dimen.platform_common_margin_size);
        setPadding(paddingLeft, 0, paddingLeft, 0);
    }

    protected void initView() {
        setOrientation(LinearLayout.VERTICAL);
        View itemView =
                LayoutInflater.from(getContext())
                        .inflate(R.layout.discover_item_common_footer_layout, this, true);
        View llfooterCoonainer = itemView.findViewById(R.id.ll_footer_container);
        View bottomSeatLayout = itemView.findViewById(R.id.bottom_seat_layout);

        mShareFuncView = itemView.findViewById(R.id.footer_share_view);
        // mForwardFuncView = itemView.findViewById(R.id.footer_forward_view);
        mEvaluateFuncView = itemView.findViewById(R.id.footer_evaluate_view);
        mPraiseFuncView = itemView.findViewById(R.id.footer_praise_view);

        // mForwardFuncView.setImageSource(R.mipmap.discover__item_bottom_forward_ic);
        mPraiseFuncView.setImageSource(R.mipmap.discover_common_item_bottom_not_parise_ic);
        mEvaluateFuncView.setImageSource(R.mipmap.discover_common_item_bottom_comment_ic);
        mShareFuncView.setImageSource(R.mipmap.discover_common_item_bottom_share_ic);

        mShareFuncView.setOnClickListener(v -> {
            if (mEventClickListener != null) {
                mEventClickListener.onShareClick(v);
            }
        });
        // mForwardFuncView.setOnClickListener(new View.OnClickListener() {
        //     @Override
        //     public void onClick(View v) {
        //         if (mOnDiscoverBaseItemClickListener != null) {
        //             mOnDiscoverBaseItemClickListener.onForwardArticleClick(articleInfo);
        //         }
        //     }
        // });
        mEvaluateFuncView.setOnClickListener(v -> {
            if (mEventClickListener != null) {
                mEventClickListener.onEvaluateClick(v);
            }
        });
        mPraiseFuncView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mEventClickListener != null) {
                    mEventClickListener.onPraiseClick(v);
                }
            }
        });
        mDiscoverTopicContentView = itemView.findViewById(R.id.topic_view);
        if(DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()){
            mDiscoverTopicContentView.setVisibility(GONE);
            llfooterCoonainer.setVisibility(View.GONE);
            bottomSeatLayout.setVisibility(View.VISIBLE);
        }
    }

    public void setEnableTopic(boolean enableTopic) {
        isEnableTopic = enableTopic;
    }

    public void setTopicData(List<ArticleTopic> topicList) {
        if (isEnableTopic && topicList != null && topicList.size() > 0) {
            mDiscoverTopicContentView.setTopicData(topicList);
            mDiscoverTopicContentView.setVisibility(View.VISIBLE);
        } else {
            mDiscoverTopicContentView.setVisibility(View.GONE);
        }
    }

    public void setTopicClickListener(OnClickListener topicClickListener) {
        mDiscoverTopicContentView.setTopicClickListener(topicClickListener);
    }

    private EventClickListener mEventClickListener;

    public void setEventClickListener(
            EventClickListener eventClickListener) {
        mEventClickListener = eventClickListener;
    }

    public interface EventClickListener {

        void onShareClick(View view);

        void onEvaluateClick(View view);

        void onPraiseClick(View view);

    }

    public void refresh(ArticleInfo articleInfo) {
        refreshEvaluateState(articleInfo);

        refreshShareState(articleInfo);
        // if (articleInfo.transmitCount > 0) {
        //     mForwardFuncView
        //             .setTextViewText(String.valueOf(articleInfo.transmitCount));
        //     mForwardFuncView.setTextViewVisible(true);
        // } else {
        //     mForwardFuncView.setTextViewVisible(false);
        // }
        refreshPraiseState(articleInfo);
    }

    public void refreshPraiseState(ArticleInfo articleInfo) {
        if (articleInfo.pointsCount > 0) {
            mPraiseFuncView.setTextViewText(
                    String.valueOf(articleInfo.pointsCount));
            mPraiseFuncView.setTextViewVisible(true);
        } else {
            mPraiseFuncView.setTextViewVisible(false);
        }
        if (articleInfo.isLikeArticle()) {
            mPraiseFuncView
                    .setImageSource(R.mipmap.discover_common_item_bottom_parise_ic);
        } else {
            mPraiseFuncView
                    .setImageSource(R.mipmap.discover_common_item_bottom_not_parise_ic);
        }
    }

    public void refreshEvaluateState(ArticleInfo articleInfo) {
        if (articleInfo.replyCount > 0) {
            mEvaluateFuncView
                    .setTextViewText(String.valueOf(articleInfo.replyCount));
            mEvaluateFuncView.setTextViewVisible(true);
        } else {
            mEvaluateFuncView.setTextViewVisible(false);
        }
    }

    public void refreshShareState(ArticleInfo articleInfo) {
        mShareFuncView.setTextViewText("分享");
        // if (articleInfo.shareCount > 0) {
        //     mShareFuncView
        //             .setTextViewText(String.valueOf(articleInfo.shareCount));
        //     mShareFuncView.setTextViewVisible(true);
        // } else {
        //     mShareFuncView.setTextViewVisible(false);
        // }
    }

    public void refreshForwardState(ArticleInfo articleInfo) {
        // if (articleInfo.transmitCount > 0) {
        //     mForwardFuncView
        //             .setTextViewText(String.valueOf(articleInfo.transmitCount));
        //     mForwardFuncView.setTextViewVisible(true);
        // } else {
        //     mForwardFuncView.setTextViewVisible(false);
        // }
    }
}
