package com.edu24ol.newclass.discover.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;

import com.edu24.data.server.discover.entity.ArticleImage;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.adapter.DiscoverShortPicListAdapter;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.widgets.RecycleViewGridItemDecoration;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class ShortArticlePictureView extends RecyclerView {

    private DiscoverShortPicListAdapter mAdapter;

    public ShortArticlePictureView(@NonNull Context context) {
        super(context);
    }

    public ShortArticlePictureView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ShortArticlePictureView(@NonNull Context context, @Nullable AttributeSet attrs,
                                   int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setPicture(List<ArticleImage> pictures) {
        if (pictures == null) {
            return;
        }

        GridLayoutManager gridLayoutManager;
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        if (pictures.size() > 1) {
            boolean isThirdTimeCount = (pictures.size() != 2 && pictures.size() != 4);
            gridLayoutManager = new GridLayoutManager(getContext(), isThirdTimeCount ? 3 : 2);
            int pictureMaxWidth = DisplayUtils.getScreenWidth(getContext()) -
                    getContext().getResources()
                            .getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;
            if (isThirdTimeCount) {
                layoutParams.width = pictureMaxWidth;
            } else {
                layoutParams.width = pictureMaxWidth - (pictureMaxWidth - DisplayUtils
                        .dip2px(getContext(), DiscoverShortPicListAdapter.DISCOVER_IMG_WIDTH) * 2) /
                        3;
            }
        } else {
            gridLayoutManager = new GridLayoutManager(getContext(), 1);
            layoutParams.width = ViewGroup.LayoutParams.WRAP_CONTENT;
        }
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        setLayoutParams(layoutParams);
        gridLayoutManager.setAutoMeasureEnabled(true);
        setLayoutManager(gridLayoutManager);
        if (mAdapter == null) {
            mAdapter = new DiscoverShortPicListAdapter(getContext());
            mAdapter.setDatas(pictures);
            mAdapter.setOnGetSizeListener((parentWidth, parentHeight) -> {
                ViewGroup.LayoutParams layoutParams1 = getLayoutParams();
                layoutParams1.width = parentWidth;
                layoutParams1.height = parentHeight;
                setLayoutParams(layoutParams1);
            });
            setAdapter(mAdapter);
        } else {
            mAdapter =
                    (DiscoverShortPicListAdapter) getAdapter();
            mAdapter.setDatas(pictures);
            mAdapter.notifyDataSetChanged();
        }
        if (getItemDecorationCount() == 0) {
            int space = DisplayUtils
                    .dip2px(getContext(), DiscoverShortPicListAdapter.DISCOVER_IMG_WIDTH);
            RecycleViewGridItemDecoration gridImgItemDecoration =
                    new RecycleViewGridItemDecoration(space, space);
            addItemDecoration(gridImgItemDecoration);
        }
    }
}
