package com.edu24ol.newclass.discover.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.hqwx.android.discover.common.R;

import androidx.constraintlayout.widget.ConstraintLayout;

/**
 * Created by zhanghong on 2019/4/15.
 */

public class ImageCountFuncView extends ConstraintLayout {

    private Context mContext;

    private ImageView mImageView;
    private TextView mTextView;

    public ImageCountFuncView(Context context) {
        this(context, null);
    }

    public ImageCountFuncView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        mContext = context;
        initView();
    }

    private void initView() {
        View view = LayoutInflater.from(mContext).inflate(R.layout.discover_image_count_func_layout, this);
        mImageView = view.findViewById(R.id.imgcnt_func_img_view);
        mTextView = view.findViewById(R.id.imgcnt_cnt_view);
    }

    public void setImageSource(int imgDrawable) {
        mImageView.setImageResource(imgDrawable);
    }

    public void setTextViewText(String text) {
        mTextView.setText(text);
    }

    public void setTextViewVisible(boolean isVisible) {
        mTextView.setVisibility(isVisible ? View.VISIBLE : View.GONE);
    }
}
