package com.edu24ol.newclass.discover.widget;

import android.content.Context;
import android.util.AttributeSet;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.edu24ol.newclass.widget.photopicker.GridPhotoView;
import com.edu24ol.newclass.widget.photopicker.GridSelectPhotoAdapter;
import com.edu24ol.newclass.widget.photopicker.adapter.DynamicPhotoAdapter;
import com.hqwx.android.platform.utils.DisplayUtils;

/**
 * 发布动态的图片view
 */
public class DynamicPhotoView extends GridPhotoView {

    public DynamicPhotoView(@NonNull Context context) {
        this(context, null);
    }

    public DynamicPhotoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DynamicPhotoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected int getDefaultColNum() {
        return 3;
    }

    public int getGridSpacing() {
        return DisplayUtils.dip2px(getContext(), 8f);
    }

    @Override
    public int getMaxPictureCount() {
        return 9;
    }

    protected GridSelectPhotoAdapter getPhotoAdapter() {
        return new DynamicPhotoAdapter(getContext(), getDefaultColNum(), getGridSpacing(), getMaxPictureCount());
    }

}
