package com.edu24ol.newclass.discover.widget

import android.content.Context
import android.os.Bundle
import android.text.Editable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.widget.addTextChangedListener
import androidx.recyclerview.widget.GridLayoutManager
import com.edu24.data.DataApiFactory
import com.edu24ol.newclass.discover.adapter.ReportArticleAdapter
import com.edu24ol.newclass.discover.model.DiscoverReportItemModel
import com.edu24ol.newclass.discover.model.DiscoverReportType
import com.edu24ol.newclass.discover.report.ReportActivityContract
import com.edu24ol.newclass.discover.report.ReportPresenter
import com.edu24ol.newclass.discover.util.DiscoverUserHelper
import com.edu24ol.newclass.widget.photopicker.GridPhotoView
import com.hqwx.android.discover.common.databinding.DiscoverCommonReportDialogBinding
import com.hqwx.android.platform.BaseActivity
import com.hqwx.android.platform.utils.DisplayUtils
import com.hqwx.android.platform.utils.ToastUtil
import com.hqwx.android.platform.widgets.BaseBottomDialog

/**
 * 从底部弹出显示在底部的列表对话框
 */
class DiscoverReportDialog : BaseBottomDialog, ReportActivityContract.IReportMvpView {
    private lateinit var mAdapter: ReportArticleAdapter
    private lateinit var mBinding: DiscoverCommonReportDialogBinding
    private var mContentId: Long = 0
    private var tipsType: Int = -1
    lateinit var presenter: ReportActivityContract.IReportPresenter<ReportActivityContract.IReportMvpView>

    constructor(context: Context, contentId: Long) : super(context) {
        mContentId = contentId
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mBinding = DiscoverCommonReportDialogBinding.inflate(LayoutInflater.from(context))
        setContentView(mBinding.root)
        //一定要在setContentView之后调用，否则无效
        window!!.setLayout(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )

        mAdapter = ReportArticleAdapter(context)
        with(mAdapter) {
            addData(DiscoverReportItemModel(DiscoverReportType(1, "低俗色情")))
            addData(DiscoverReportItemModel(DiscoverReportType(2, "垃圾广告")))
            addData(DiscoverReportItemModel(DiscoverReportType(3, "涉嫌违法犯罪")))
            addData(DiscoverReportItemModel(DiscoverReportType(4, "内容不实")))
            addData(DiscoverReportItemModel(DiscoverReportType(5, "人身攻击")))
            addData(DiscoverReportItemModel(DiscoverReportType(6, "侵权投诉")))
            setOnCheckedChangeListener { reportType ->
                tipsType = reportType.type
                mBinding.submit.isEnabled = true
            }
        }
        mBinding.recycleView.layoutManager = GridLayoutManager(context, 3)
        val itemDecoration = GridPhotoView.GridItemDecoration(
            context, 3, DisplayUtils.dip2px(context, 18f)
        )
        mBinding.recycleView.addItemDecoration(itemDecoration)
        mBinding.recycleView.adapter = mAdapter
        mBinding.editText.addTextChangedListener { text: Editable? ->
            if (text != null) {
                mBinding.textCount.text = "${text.length}/200"
            }
        }
        mBinding.submit.setOnClickListener { v: View? ->
            val content = mBinding.editText.text.toString()
            if (tipsType == -1) {
                ToastUtil.showMessage(v!!.context, "请选择举报类型")
            } else {
                presenter.submitReport(DiscoverUserHelper.getAuthorization(), mContentId, content, tipsType)
            }
        }
        presenter = ReportPresenter(DataApiFactory.getInstance().discoverjApi)
        setCanceledOnTouchOutside(false)
        setCancelable(false)
        mBinding.closeIcon.setOnClickListener {
            dismiss()
        }
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        presenter.onAttach(this)
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        presenter.onDetach()
    }

    override fun onSubmitSuccess() {
        ToastUtil.showMessageWithSuccess(mContext, "举报成功")
        dismiss()
    }

    override fun onSubmitFailure(t: Throwable) {
        ToastUtil.showMessage(mContext, t.message)
    }

    override fun isActive(): Boolean {
        if (mContext is BaseActivity) {
            return (mContext as BaseActivity).isActive
        }
        return false
    }

    override fun showLoading() {
        if (mContext is BaseActivity) {
            (mContext as BaseActivity).showLoading()
        }
    }

    override fun hideLoading() {
        if (mContext is BaseActivity) {
            (mContext as BaseActivity).hideLoading()
        }
    }

    override fun showLoadingView() {
        if (mContext is BaseActivity) {
            (mContext as BaseActivity).showLoadingView()
        }
    }

    override fun hideLoadingView() {
        if (mContext is BaseActivity) {
            (mContext as BaseActivity).hideLoadingView()
        }
    }
}