package com.edu24ol.newclass.discover.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;

import com.hqwx.android.discover.common.R;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import static com.edu24ol.newclass.discover.adapter.DiscoverBaseArticleListAdapter.RECOMMEND_LAST_READ_TYPE;

/**
 * Created by zhanghong on 2019/4/22.
 */

public class DiscoverRecommendItemDecoration extends RecyclerView.ItemDecoration {
    private Drawable mDivider;

    private Paint mPaint;
    private int mHeightDp;

    public DiscoverRecommendItemDecoration(Context context) {
        mDivider = context.getResources().getDrawable(R.drawable.platform_shape_list_divider);
    }

    public DiscoverRecommendItemDecoration(Context context, int color, int heightDp) {
        mPaint = new Paint();
        mPaint.setStyle(Paint.Style.FILL);
        mPaint.setColor(color);
        mHeightDp = heightDp;
    }

    @Override
    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view,
                               @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int viewType = parent.getAdapter().getItemViewType(position);
        if (viewType != RECOMMEND_LAST_READ_TYPE) {
            outRect.set(0, 0, 0, mHeightDp);
        } else {
            outRect.setEmpty();
        }
    }

    private boolean hasDividerOnBottom(View view, RecyclerView parent, RecyclerView.State state) {
        int position =
                ((RecyclerView.LayoutParams) view.getLayoutParams()).getViewAdapterPosition();
        return position < state.getItemCount() &&
                parent.getAdapter().getItemViewType(position) != RECOMMEND_LAST_READ_TYPE;
    }

    @Override
    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        for (int i = 0; i < parent.getChildCount(); i++) {
            View view = parent.getChildAt(i);
            if (hasDividerOnBottom(view, parent, state)) {
                c.drawRect(view.getLeft(), view.getBottom(), view.getRight(),
                        view.getBottom() + mHeightDp, mPaint);
            }
        }
    }
}

