package com.edu24ol.newclass.discover.widget;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.util.DiscoverUserHelper;
import com.hqwx.android.discover.common.databinding.DiscoverMenuItemPopwindowBinding;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.widgets.HqPopupWindow;

public class DiscoverItemMenuWindow extends HqPopupWindow {

    private DiscoverMenuItemPopwindowBinding mBinding;

    private Context mContext;

    public DiscoverItemMenuWindow(ArticleInfo articleInfo, Context context) {
        super(context);
        mContext = context;
        setWidth(WindowManager.LayoutParams.WRAP_CONTENT);
        setHeight(WindowManager.LayoutParams.WRAP_CONTENT);
        mBinding = DiscoverMenuItemPopwindowBinding.inflate(LayoutInflater.from(mContext));
        setContentView(mBinding.getRoot());
        // mBinding.getRoot().setBackgroundColor(Color.RED);
        setTouchable(true);
        setOutsideTouchable(true);
        setClippingEnabled(false);
        boolean isArticleOwner = articleInfo.isCurrentLoginUserEqualAuthor(DiscoverUserHelper.getUserId());
        if (isArticleOwner) {
            mBinding.reportView.setVisibility(View.GONE);
        } else {
            mBinding.deleteView.setVisibility(View.GONE);
        }
        mBinding.line2.setVisibility(View.GONE);

        mBinding.shareView.setOnClickListener((view) -> {
            if (mMenuItemClickListener != null) {
                mMenuItemClickListener.onShareClick();
            }
            dismiss();
        });
        mBinding.reportView.setOnClickListener((view) -> {
            if (mMenuItemClickListener != null) {
                mMenuItemClickListener.onReportClick();
            }
            dismiss();
        });
        mBinding.deleteView.setOnClickListener((view) -> {
            if (mMenuItemClickListener != null) {
                mMenuItemClickListener.onDeleteClick();
            }
            dismiss();
        });
        setOnDismissListener(() -> changeWindowAlpha(1.0f));
    }

    public void show(View anchor) {
        View contentView = getContentView();
        contentView.measure(makeDropDownMeasureSpec(getWidth()), makeDropDownMeasureSpec(getHeight()));
        int width = contentView.getMeasuredWidth();
        int triangleX = (width / 2) - (116 * width / 424);
        int xOff = anchor.getWidth() / 2 - width /2 - triangleX;
        showAsDropDown(anchor, xOff,
                0 - DisplayUtils.dip2px(mContext,12));
        changeWindowAlpha(1f);
    }

    @SuppressWarnings("ResourceType")
    private static int makeDropDownMeasureSpec(int measureSpec) {
        int mode;
        if (measureSpec == ViewGroup.LayoutParams.WRAP_CONTENT) {
            mode = View.MeasureSpec.UNSPECIFIED;
        } else {
            mode = View.MeasureSpec.EXACTLY;
        }
        return View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(measureSpec), mode);
    }

    private MenuItemClickListener mMenuItemClickListener;

    public void setMenuItemClickListener(
        MenuItemClickListener menuItemClickListener) {
        mMenuItemClickListener = menuItemClickListener;
    }

    public interface MenuItemClickListener {
        void onShareClick();

        void onReportClick();

        void onDeleteClick();
    }

    private void changeWindowAlpha(float toAlpha) {
        Window window = ((Activity) (mContext)).getWindow();
        final WindowManager.LayoutParams attributes = window.getAttributes();
        attributes.flags = attributes.flags | WindowManager.LayoutParams.FLAG_DIM_BEHIND;
        attributes.dimAmount = toAlpha;
        attributes.alpha = toAlpha;
        window.setAttributes(attributes);
    }

    @Override
    protected int getWindowWidth() {
        return ViewGroup.LayoutParams.WRAP_CONTENT;
    }
}
