package com.edu24ol.newclass.discover.widget

import android.graphics.drawable.Drawable
import android.widget.ImageView
import com.bumptech.glide.request.target.DrawableImageViewTarget
import com.bumptech.glide.request.transition.Transition
import com.hqwx.android.discover.common.R

import com.hqwx.android.platform.utils.DisplayUtils
import com.yy.android.educommon.log.YLog

/**
 * 默认占位图
 * Create by Hal 2021/9/14
 */
class DefaultImageViewTarget(imageView: ImageView) : DrawableImageViewTarget(imageView) {

    override fun onLoadStarted(placeholder: Drawable?) {
        super.onLoadStarted(placeholder)
        showDefaultPlaceHolderBg()
    }

    private fun showDefaultPlaceHolderBg() {
        val padding = DisplayUtils.dip2px(getView().context, 10F)
        getView().scaleType = ImageView.ScaleType.CENTER_INSIDE
        getView().setPadding(padding, 0, padding, 0)
        getView().setBackgroundResource(R.drawable.discover_common_default_image_placeholder_bg)
        getView().setImageResource(R.mipmap.discover_common_ic_hqwx)
    }

    override fun onResourceReady(resource: Drawable, transition: Transition<in Drawable>?) {
        getView().scaleType = ImageView.ScaleType.FIT_XY
        getView().setPadding(0, 0, 0, 0)
        getView().setBackgroundResource(0)
        //YLog.info(this, "keepon onResourceReady ")
        super.onResourceReady(resource, transition)
    }

    override fun onLoadFailed(errorDrawable: Drawable?) {
        super.onLoadFailed(errorDrawable)
        YLog.info(this, "keepon onLoadFailed ")
        showDefaultPlaceHolderBg()
    }

    override fun onDestroy() {
        super.onDestroy()
    }
}