package com.edu24ol.newclass.discover.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.hqwx.android.discover.common.R;

import static com.edu24ol.newclass.discover.adapter.DiscoverBaseArticleListAdapter.RECOMMEND_LAST_READ_TYPE;



public class CommonItemDecoration extends RecyclerView.ItemDecoration {
    private Drawable mDivider;

    private Paint mPaint;
    private int mHeightDp;
    private int mMargin;

    public CommonItemDecoration(Context context, int color, int heightDp,int margin) {
        mPaint = new Paint();
        mPaint.setStyle(Paint.Style.FILL);
        mPaint.setColor(color);
        mHeightDp = heightDp;
        mMargin = margin;
    }

    @Override
    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view,
                               @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int itemCount = parent.getAdapter().getItemCount();
        if(itemCount > 1) {
            if (position == 0) {
                outRect.set(0, 0, 0, mHeightDp + mMargin);
            } else if (position == itemCount - 1) {
                outRect.set(0, mMargin, 0, 0);
            } else {
                outRect.set(0, mMargin, 0, mHeightDp + mMargin);
            }
        }
    }


    @Override
    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int count = parent.getChildCount();
        if(count > 1) {
            for (int i = 0; i < count; i++) {
                View view = parent.getChildAt(i);
                c.drawRect(view.getLeft(), view.getBottom() + mMargin, view.getRight(),
                        view.getBottom() + mMargin + mHeightDp, mPaint);

            }
        }
    }
}

