package com.edu24ol.newclass.discover.viewholder;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.model.DiscoverReportItemModel;
import com.hqwx.android.platform.adapter.BaseViewHolderNew;

/**
 * 举报
 */
public class DiscoverReportItemViewHolder extends BaseViewHolderNew<DiscoverReportItemModel> {

    TextView mTitleText;
    //免息
    ImageView nBugIcon;

    public DiscoverReportItemViewHolder(View itemView) {
        super(itemView);
        mTitleText = itemView.findViewById(R.id.item_title);
        nBugIcon = itemView.findViewById(R.id.bug_icon);
    }

    @Override
    public void onBindViewHolder(Context context, DiscoverReportItemModel model, int position) {
        super.onBindViewHolder(context, model, position);
        mTitleText.setText(model.getItemInfo().getTitle());
        if (model.getItemInfo().isChecked()) {
            itemView.setSelected(true);
            nBugIcon.setVisibility(View.VISIBLE);
        } else {
            itemView.setSelected(false);
            nBugIcon.setVisibility(View.GONE);
        }
    }

}
