package com.edu24ol.newclass.discover.viewholder;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;

import com.edu24.data.server.discover.entity.ArticleInfo;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.widget.article.DiscoverForwardContentView;

public class DiscoverForwardArticleBaseItemViewHolder<K extends ViewGroup> extends
        DiscoverBaseArticleListItemViewHolder<K> {

    protected DiscoverForwardContentView mDiscoverForwardContentView;

    public DiscoverForwardArticleBaseItemViewHolder(Context context,
                                                    View itemView) {
        super(context, itemView);
        mDiscoverForwardContentView = itemView.findViewById(R.id.text_forward_content);
        mArticleView.setForwardUISetter();
        mArticleView.getRoot().setOnClickListener(v -> {
            ArticleInfo forwardArticleInfo = (ArticleInfo) v.getTag();
            mCommonEventListener.onForwardArticleItemClick(forwardArticleInfo);
        });
    }

    @Override
    public void onBindViewHolder(Context context, ArticleInfo articleInfo, int position) {
        super.onBindViewHolder(context, articleInfo, position);
        mDiscoverForwardContentView.refreshForwardContent(articleInfo);
        if (articleInfo.getRootParentArticle() == null) {
            mArticleView.setViewVisible(false);
        } else {
            mArticleView.setViewVisible(true);
            final ArticleInfo forwardArticleInfo = articleInfo.getRootParentArticle();
            mArticleView.refreshArticleInfo(forwardArticleInfo, position, isShowTag());
            mArticleView.getRoot().setTag(forwardArticleInfo);
        }
    }
}
