package com.edu24ol.newclass.discover.viewholder;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;

import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.discover.entity.ArticleTopic;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.widget.article.DiscoverArticleFooterView;
import com.hqwx.android.platform.stat.Referrer;
import com.hqwx.android.service.AppRouter;
import com.hqwx.android.service.difference.DifferenceConfig;

import java.util.List;

public class DiscoverBaseArticleListItemViewHolder<K extends ViewGroup>
        extends DiscoverBaseArticleItemViewHolder<K> {

    protected DiscoverArticleFooterView mFooterView;

    public DiscoverBaseArticleListItemViewHolder(Context context, View itemView) {
        super(context, itemView);
        mFooterView = getArticleFooterView(itemView);
        initListener();
    }

    protected DiscoverArticleFooterView getArticleFooterView(View itemView){
        return itemView.findViewById(R.id.discover_footer_view);
    }

    protected void initListener(){
        mFooterView.setEventClickListener(new DiscoverArticleFooterView.EventClickListener() {
            @Override
            public void onShareClick(View view) {
                ArticleInfo articleInfo = (ArticleInfo) itemView.getTag();
                if (articleInfo == null) {
                    return;
                }
                if (mFooterEventListener != null) {
                    mFooterEventListener.onShareArticleClick(articleInfo);
                }
            }

            @Override
            public void onEvaluateClick(View view) {
                ArticleInfo articleInfo = (ArticleInfo) itemView.getTag();
                if (articleInfo == null) {
                    return;
                }
                if (mFooterEventListener != null) {
                    int position = (int) itemView.getTag(R.id.tag_position);
                    articleInfo.postion = position;
                    mFooterEventListener.onEvaluateArticleClick(articleInfo);
                }
            }

            @Override
            public void onPraiseClick(View view) {
                ArticleInfo articleInfo = (ArticleInfo) itemView.getTag();
                if (articleInfo == null) {
                    return;
                }
                int position = (int) itemView.getTag(R.id.tag_position);
                if (mFooterEventListener != null) {
                    mFooterEventListener.onPraiseArticleClick(articleInfo, position);
                }
            }
        });
        mFooterView.setTopicClickListener(v -> {
            if (v.getTag() == null) {
                return;
            }
            ArticleTopic topic = (ArticleTopic) v.getTag();
            AppRouter.startDiscoverTopicDetailActivity(v.getContext(), topic.getId(),
                    Referrer.getInstance().getCurrentFragmentPageName(), "内容详情页");
        });
        itemView.setOnClickListener(v -> {
            ArticleInfo articleInfo = (ArticleInfo) itemView.getTag();
            if (articleInfo == null) {
                return;
            }
            if(DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()){
                return;
            }
            if (mCommonEventListener != null) {
                int position = (int) itemView.getTag(R.id.tag_position);
                articleInfo.postion = position;
                mCommonEventListener.onArticleItemClick(articleInfo);
            }
        });
    }

    @Override
    public void onBindViewHolder(Context context, final ArticleInfo articleInfo, int position) {
        super.onBindViewHolder(context, articleInfo, position);
        mFooterView.refresh(articleInfo);
        mFooterView.setTopicData(articleInfo.getArticleTopics());
    }

    @Override
    public void onBindViewHolder(Context context, ArticleInfo articleInfo,
                                 List payloads, int position) {
        super.onBindViewHolder(context, articleInfo, payloads, position);
        String payLoad = (String) payloads.get(0);
        if ("praise".equals(payLoad)) {
            mFooterView.refreshPraiseState(articleInfo);
        } else if ("replayCount".equals(payLoad)) {
            mFooterView.refreshEvaluateState(articleInfo);
        } else if ("shareCount".equals(payLoad)) {
            mFooterView.refreshShareState(articleInfo);
        } else if ("transmitCount".equals(payLoad)) {
            mFooterView.refreshForwardState(articleInfo);
        }

    }

    protected DiscoverArticleEvent.CommonEventListener mCommonEventListener;

    public void setCommonEventListener(
            DiscoverArticleEvent.CommonEventListener commonEventListener) {
        mCommonEventListener = commonEventListener;
    }

    protected DiscoverArticleEvent.FooterEventListener mFooterEventListener;

    public void setFooterEventListener(
            DiscoverArticleEvent.FooterEventListener footerEventListener) {
        mFooterEventListener = footerEventListener;
    }

}
