package com.edu24ol.newclass.discover.viewholder;

import android.content.Context;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.util.DiscoverUserHelper;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.widget.DiscoverItemMenuWindow;
import com.edu24ol.newclass.discover.widget.article.DiscoverArticleHeaderView;
import com.edu24ol.newclass.discover.widget.article.IArticleView;
import com.hqwx.android.platform.adapter.BaseViewHolderNew;
import com.hqwx.android.service.difference.DifferenceConfig;

import java.util.List;

public class DiscoverBaseArticleItemViewHolder<K extends ViewGroup>
        extends BaseViewHolderNew<ArticleInfo> {

    protected DiscoverArticleHeaderView mHeaderView;

    protected IArticleView<K> mArticleView;

    public DiscoverBaseArticleItemViewHolder(Context context, View itemView) {
        super(context, itemView);
        mArticleView = getArticleView();
        mHeaderView = initHeaderView(context, itemView);
        initHeaderViewListener();
    }

    public DiscoverArticleHeaderView initHeaderView(Context context, View itemView) {
        return itemView.findViewById(R.id.discover_header_view);
    }

    protected IArticleView<K> getArticleView() {
        return itemView.findViewById(R.id.article_content_view);
    }

    protected void initHeaderViewListener() {
        mHeaderView.setEventClickListener(new DiscoverArticleHeaderView.EventClickListener() {
            @Override
            public void onMoreClick(View view) {
                ArticleInfo articleInfo = (ArticleInfo) itemView.getTag();
                if (articleInfo == null) {
                    return;
                }
                DiscoverItemMenuWindow discoverItemMenuWindow =
                        new DiscoverItemMenuWindow(articleInfo, view.getContext());
                discoverItemMenuWindow.setMenuItemClickListener(
                        new DiscoverItemMenuWindow.MenuItemClickListener() {
                            @Override
                            public void onShareClick() {
                                if (mMoreMenuEventListener != null) {
                                    mMoreMenuEventListener.onMenuShareClick(articleInfo);
                                }
                            }

                            @Override
                            public void onReportClick() {
                                if (mMoreMenuEventListener != null) {
                                    mMoreMenuEventListener.onMenuReportClick(articleInfo);
                                }
                            }

                            @Override
                            public void onDeleteClick() {
                                if (mMoreMenuEventListener != null) {
                                    mMoreMenuEventListener.onMenuDeleteClick(articleInfo);
                                }
                            }
                        });
                discoverItemMenuWindow.show(view);
            }

            @Override
            public void onAttentionClick(CheckBox checkBox) {
                ArticleInfo articleInfo = (ArticleInfo) itemView.getTag();
                if (articleInfo == null || articleInfo.author == null) {
                    return;
                }
                if (mHeaderEventListener != null) {
                    mHeaderEventListener
                            .onAttentionClick(checkBox, articleInfo.author, checkBox.isChecked());
                }
            }
        });
        mHeaderView.setOnClickListener(v -> {
            ArticleInfo articleInfo = (ArticleInfo) itemView.getTag();
            if (articleInfo == null || articleInfo.author == null) {
                return;
            }
            if(DifferenceConfig.discoverDifferenceService.isHideDiscoverCellInteractive()){
                return;
            }
            if (mHeaderEventListener != null) {
                mHeaderEventListener.onAuthorInfoClick(articleInfo.author);
            }
        });
    }

    @Override
    public void onBindViewHolder(Context context, final ArticleInfo articleInfo, int position) {
        setAttentionAndMoreState(articleInfo);
        mHeaderView.refresh(articleInfo);
        itemView.setTag(articleInfo);
        itemView.setTag(R.id.tag_position, position);
        mArticleView.refreshArticleInfo(articleInfo, position, isShowTag());
    }

    @Override
    public void onBindViewHolder(Context context, ArticleInfo articleInfo,
                                 List payloads, int position) {
        String payLoad = (String) payloads.get(0);
        if ("attention".equals(payLoad)) {
            mHeaderView.refreshAttentionState(articleInfo);
        }
    }

    protected DiscoverArticleEvent.HeaderEventListener mHeaderEventListener;

    public void setHeaderEventListener(
            DiscoverArticleEvent.HeaderEventListener headerEventListener) {
        mHeaderEventListener = headerEventListener;
    }

    protected DiscoverArticleEvent.MoreMenuEventListener mMoreMenuEventListener;

    public void setMoreMenuEventListener(
            DiscoverArticleEvent.MoreMenuEventListener moreMenuEventListener) {
        mMoreMenuEventListener = moreMenuEventListener;
    }

    private boolean isShowAttention;
    private boolean isShowMoreButton;
    private boolean isShowTag;

    public boolean isShowTag() {
        return isShowTag;
    }

    public void setShowTag(boolean showTag) {
        isShowTag = showTag;
    }

    public boolean isShowAttention() {
        return isShowAttention;
    }

    public void setShowAttention(boolean showAttention) {
        isShowAttention = showAttention;
    }

    public boolean isShowMoreButton() {
        return isShowMoreButton;
    }

    public void setShowMoreButton(boolean showMoreButton) {
        isShowMoreButton = showMoreButton;
    }

    protected void setAttentionAndMoreState(ArticleInfo articleInfo) {
        boolean isArticleOwner = articleInfo.isCurrentLoginUserEqualAuthor(DiscoverUserHelper.getUserId());
        mHeaderView.showAttentionView(isShowAttention() && !isArticleOwner);
        mHeaderView.showMoreView(isShowMoreButton());
    }

    public void setContentTextSize(float size) {
        TextView contentView = mArticleView.getContentView();
        if (contentView != null) {
            contentView.setTextSize(TypedValue.COMPLEX_UNIT_SP, size);
        }
    }

    public void setAuthorNameTextSize(float size) {
        mHeaderView.onSetAuthorNameTextSize(size);
    }

    public void setAuthorNameTextStyle(boolean fakeBoldText) {
        mHeaderView.onSetAuthorNameTextStyle(fakeBoldText);
    }

    public void setAuthorNameTextColor(int color) {
        mHeaderView.onSetAuthorNameTextColor(color);
    }
}
