package com.edu24ol.newclass.discover.viewholder;

import android.content.Context;
import android.view.View;

import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24ol.newclass.discover.widget.article.DiscoverArticleViewShort;

import java.util.List;

/**
 * 列表动态短图文
 */
public class DiscoverArticleItemViewHolderShort extends
        DiscoverBaseArticleListItemViewHolder<DiscoverArticleViewShort> {

    public DiscoverArticleItemViewHolderShort(Context context, View itemView) {
        super(context, itemView);
        mArticleView.setArticleEventListener(
            (DiscoverArticleViewShort.ArticleEventListener) groupListBean -> {
                if (mCommonEventListener != null) {
                    mCommonEventListener.onRecommendCourseClick(groupListBean);
                }
            });
    }

    @Override
    public void onBindViewHolder(Context context, ArticleInfo articleInfo, int position) {
        super.onBindViewHolder(context, articleInfo, position);
    }

    @Override
    public void onBindViewHolder(Context context,
                                 ArticleInfo articleInfo,
                                 List payloads, int position) {
        String payLoad = (String) payloads.get(0);
        if ("refreshTitle".equals(payLoad)) {
            mArticleView.getRoot().refreshTitle(articleInfo, isShowTag());
        }
        super.onBindViewHolder(context, articleInfo, payloads, position);
    }

}
