package com.edu24ol.newclass.discover.viewholder;

import android.widget.CheckBox;

import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.entity.GoodsGroupListBean;

import androidx.annotation.NonNull;

public interface DiscoverArticleEvent {

    interface HeaderEventListener {

        void onAuthorInfoClick(@NonNull ArticleAuthor author);

        void onAttentionClick(CheckBox checkBox, @NonNull ArticleAuthor author, boolean attention);

    }

    interface MoreMenuEventListener {

        void onMenuShareClick(@NonNull ArticleInfo articleInfo);

        void onMenuReportClick(@NonNull ArticleInfo articleInfo);

        void onMenuDeleteClick(@NonNull ArticleInfo articleInfo);
    }

    interface FooterEventListener {

        void onShareArticleClick(@NonNull ArticleInfo articleInfo);

        //底部我的转发点击
        void onForwardArticleClick(@NonNull ArticleInfo articleInfo);

        void onEvaluateArticleClick(@NonNull ArticleInfo articleInfo);

        void onPraiseArticleClick(@NonNull ArticleInfo articleInfo, int handlePosition);

    }

    interface CommonEventListener {
        void onArticleItemClick(@NonNull ArticleInfo articleInfo);

        void onArticleItemClick(@NonNull ArticleInfo articleInfo, @NonNull String belongSeat);

        void onForwardArticleItemClick(@NonNull ArticleInfo articleInfo);

        void onRecommendCourseClick(GoodsGroupListBean goodsGroupListBean);
    }


}
