package com.edu24ol.newclass.discover.util;

import android.content.Context;
import android.util.Pair;

import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.utils.DisplayUtils;

/**
 * Time:2022/11/30 19:01
 * Author:
 * Description:
 */
public class RatioUtil
{
    public static Pair<Integer,Integer> fixRatioUtil(Context context,int videoWidth,int videoHeight){
        int maxWidth = DisplayUtils.getScreenWidth(context) - context.getResources()
            .getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;
        int maxHeight = maxWidth;
        float maxAspectRatio = (float) maxWidth / (float) maxHeight;
        float displayAspectRatio = (float) videoWidth / (float) videoHeight;
        boolean shouldBeWider = displayAspectRatio > maxAspectRatio;
        int width = videoWidth;
        int height = videoHeight;
        if (shouldBeWider) {
            // too wide, fix width
            width = Math.min(videoWidth, maxWidth);
            height = (int) (width / displayAspectRatio);
        } else {
            // too high, fix height
            height = Math.min(height, maxHeight);
            width = (int) (height * displayAspectRatio);
        }
        return new Pair(width, height);
    }
}
