package com.edu24ol.newclass.discover.util;

import java.util.Objects;

/**
 * Time:2022/12/5 11:29
 * Author:
 * Description:
 */
public class PartUploader {
    private String filePath;
    private String uploadFileName;
    private long startPos;

    private long partSize;
    private int partNumber;
    private String uploadId;

    public PartUploader(String filePath, String uploadFileName, long startPos, long partSize, int partNumber, String uploadId) {
        this.filePath = filePath;
        this.uploadFileName = uploadFileName;
        this.startPos = startPos;
        this.partSize = partSize;
        this.partNumber = partNumber;
        this.uploadId = uploadId;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getStartPos() {
        return startPos;
    }

    public void setStartPos(long startPos) {
        this.startPos = startPos;
    }

    public long getPartSize() {
        return partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public int getPartNumber() {
        return partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public String getUploadId() {
        return uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getUploadFileName() {
        return uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PartUploader that = (PartUploader) o;
        return startPos == that.startPos && partSize == that.partSize && partNumber == that.partNumber && Objects.equals(filePath, that.filePath) && Objects.equals(uploadFileName, that.uploadFileName) && Objects.equals(uploadId, that.uploadId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(filePath, uploadFileName, startPos, partSize, partNumber, uploadId);
    }
}
