package com.edu24ol.newclass.discover.util;

import android.text.TextUtils;

import com.edu24.data.server.entity.UdbToken;
import com.hqwx.android.service.ServiceFactory;
import com.hqwx.android.service.account.IAccountService;

/**
 * 获取用户相关信息，使用 {@link IAccountService},
 *
 * @see ServiceFactory#getAccountService()
 */
public class DiscoverUserHelper {



    public static boolean isMobileVerified() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.isMobileVerified();
    }

    public static String getNickname() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.getNickName();
    }

    public static String getAvatar() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.getAvatarUrl();
    }

    /**
     * 获取用户ID
     */
    public static long getUserId() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.getUid();
    }

    /**
     * 获取用户SecInfo
     */
    public static String getUserSecInfo() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.getSecInfo();
    }

    /**
     * 获取用户SecInfo
     */
    public static String getUserSecToken() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.getSecToken();
    }



    public static boolean isLogined() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.isLogin();
    }

    /**
     * 票据
     */
    public static String getAuthorization() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.getHqToken();
    }



    public static UdbToken sUdbToken;

    /**
     * 兼容方法，返回昵称或者用户名
     *
     * @return
     * @deprecated
     */
    public static String getName() {
        IAccountService accountService = ServiceFactory.getAccountService();
        if (TextUtils.isEmpty(accountService.getNickName())) {
            return accountService.getName();
        } else {
            return accountService.getNickName();
        }
    }

    /**
     * 返回登录用户名
     *
     * @return
     */
    public static String getAccountName() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.getName();
    }

    public static String getPhone() {
        IAccountService accountService = ServiceFactory.getAccountService();
        return accountService.getPhone();
    }
}
